/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The details of a UI modification&#39;s context, which define where to activate the UI modification.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class UiModificationContextDetails {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_PROJECT_ID = "projectId";
  @SerializedName(SERIALIZED_NAME_PROJECT_ID)
  private String projectId;

  public static final String SERIALIZED_NAME_ISSUE_TYPE_ID = "issueTypeId";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPE_ID)
  private String issueTypeId;

  public static final String SERIALIZED_NAME_VIEW_TYPE = "viewType";
  @SerializedName(SERIALIZED_NAME_VIEW_TYPE)
  private String viewType;

  public static final String SERIALIZED_NAME_IS_AVAILABLE = "isAvailable";
  @SerializedName(SERIALIZED_NAME_IS_AVAILABLE)
  private Boolean isAvailable;

  public UiModificationContextDetails() {
  }

  
  public UiModificationContextDetails(
     String id, 
     Boolean isAvailable
  ) {
    this();
    this.id = id;
    this.isAvailable = isAvailable;
  }

   /**
   * The ID of the UI modification context.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




  public UiModificationContextDetails projectId(String projectId) {
    
    this.projectId = projectId;
    return this;
  }

   /**
   * The project ID of the context.
   * @return projectId
  **/
  @jakarta.annotation.Nonnull

  public String getProjectId() {
    return projectId;
  }


  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }


  public UiModificationContextDetails issueTypeId(String issueTypeId) {
    
    this.issueTypeId = issueTypeId;
    return this;
  }

   /**
   * The issue type ID of the context.
   * @return issueTypeId
  **/
  @jakarta.annotation.Nonnull

  public String getIssueTypeId() {
    return issueTypeId;
  }


  public void setIssueTypeId(String issueTypeId) {
    this.issueTypeId = issueTypeId;
  }


  public UiModificationContextDetails viewType(String viewType) {
    
    this.viewType = viewType;
    return this;
  }

   /**
   * The view type of the context. Only &#x60;GIC&#x60; (Global Issue Create) is supported.
   * @return viewType
  **/
  @jakarta.annotation.Nonnull

  public String getViewType() {
    return viewType;
  }


  public void setViewType(String viewType) {
    this.viewType = viewType;
  }


   /**
   * Whether a context is available. For example, when a project is deleted the context becomes unavailable.
   * @return isAvailable
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsAvailable() {
    return isAvailable;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UiModificationContextDetails uiModificationContextDetails = (UiModificationContextDetails) o;
    return Objects.equals(this.id, uiModificationContextDetails.id) &&
        Objects.equals(this.projectId, uiModificationContextDetails.projectId) &&
        Objects.equals(this.issueTypeId, uiModificationContextDetails.issueTypeId) &&
        Objects.equals(this.viewType, uiModificationContextDetails.viewType) &&
        Objects.equals(this.isAvailable, uiModificationContextDetails.isAvailable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, projectId, issueTypeId, viewType, isAvailable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UiModificationContextDetails {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    issueTypeId: ").append(toIndentedString(issueTypeId)).append("\n");
    sb.append("    viewType: ").append(toIndentedString(viewType)).append("\n");
    sb.append("    isAvailable: ").append(toIndentedString(isAvailable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("projectId");
    openapiFields.add("issueTypeId");
    openapiFields.add("viewType");
    openapiFields.add("isAvailable");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("projectId");
    openapiRequiredFields.add("issueTypeId");
    openapiRequiredFields.add("viewType");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to UiModificationContextDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!UiModificationContextDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in UiModificationContextDetails is not found in the empty JSON string", UiModificationContextDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!UiModificationContextDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UiModificationContextDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : UiModificationContextDetails.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("projectId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `projectId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("projectId").toString()));
      }
      if (!jsonObj.get("issueTypeId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueTypeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issueTypeId").toString()));
      }
      if (!jsonObj.get("viewType").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `viewType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("viewType").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!UiModificationContextDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'UiModificationContextDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<UiModificationContextDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(UiModificationContextDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<UiModificationContextDetails>() {
           @Override
           public void write(JsonWriter out, UiModificationContextDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public UiModificationContextDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of UiModificationContextDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of UiModificationContextDetails
  * @throws IOException if the JSON string is invalid with respect to UiModificationContextDetails
  */
  public static UiModificationContextDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, UiModificationContextDetails.class);
  }

 /**
  * Convert an instance of UiModificationContextDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

