/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about the project.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class UpdateProjectDetails {
  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_LEAD = "lead";
  @SerializedName(SERIALIZED_NAME_LEAD)
  private String lead;

  public static final String SERIALIZED_NAME_LEAD_ACCOUNT_ID = "leadAccountId";
  @SerializedName(SERIALIZED_NAME_LEAD_ACCOUNT_ID)
  private String leadAccountId;

  public static final String SERIALIZED_NAME_URL = "url";
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  /**
   * The default assignee when creating issues for this project.
   */
  @JsonAdapter(AssigneeTypeEnum.Adapter.class)
  public enum AssigneeTypeEnum {
    PROJECT_LEAD("PROJECT_LEAD"),
    
    UNASSIGNED("UNASSIGNED");

    private String value;

    AssigneeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AssigneeTypeEnum fromValue(String value) {
      for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AssigneeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AssigneeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AssigneeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AssigneeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ASSIGNEE_TYPE = "assigneeType";
  @SerializedName(SERIALIZED_NAME_ASSIGNEE_TYPE)
  private AssigneeTypeEnum assigneeType;

  public static final String SERIALIZED_NAME_AVATAR_ID = "avatarId";
  @SerializedName(SERIALIZED_NAME_AVATAR_ID)
  private Long avatarId;

  public static final String SERIALIZED_NAME_ISSUE_SECURITY_SCHEME = "issueSecurityScheme";
  @SerializedName(SERIALIZED_NAME_ISSUE_SECURITY_SCHEME)
  private Long issueSecurityScheme;

  public static final String SERIALIZED_NAME_PERMISSION_SCHEME = "permissionScheme";
  @SerializedName(SERIALIZED_NAME_PERMISSION_SCHEME)
  private Long permissionScheme;

  public static final String SERIALIZED_NAME_NOTIFICATION_SCHEME = "notificationScheme";
  @SerializedName(SERIALIZED_NAME_NOTIFICATION_SCHEME)
  private Long notificationScheme;

  public static final String SERIALIZED_NAME_CATEGORY_ID = "categoryId";
  @SerializedName(SERIALIZED_NAME_CATEGORY_ID)
  private Long categoryId;

  public UpdateProjectDetails() {
  }

  public UpdateProjectDetails key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public UpdateProjectDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the project.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public UpdateProjectDetails description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A brief description of the project.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public UpdateProjectDetails lead(String lead) {
    
    this.lead = lead;
    return this;
  }

   /**
   * This parameter is deprecated because of privacy changes. Use &#x60;leadAccountId&#x60; instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Cannot be provided with &#x60;leadAccountId&#x60;.
   * @return lead
  **/
  @jakarta.annotation.Nullable

  public String getLead() {
    return lead;
  }


  public void setLead(String lead) {
    this.lead = lead;
  }


  public UpdateProjectDetails leadAccountId(String leadAccountId) {
    
    this.leadAccountId = leadAccountId;
    return this;
  }

   /**
   * The account ID of the project lead. Cannot be provided with &#x60;lead&#x60;.
   * @return leadAccountId
  **/
  @jakarta.annotation.Nullable

  public String getLeadAccountId() {
    return leadAccountId;
  }


  public void setLeadAccountId(String leadAccountId) {
    this.leadAccountId = leadAccountId;
  }


  public UpdateProjectDetails url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * A link to information about this project, such as project documentation
   * @return url
  **/
  @jakarta.annotation.Nullable

  public String getUrl() {
    return url;
  }


  public void setUrl(String url) {
    this.url = url;
  }


  public UpdateProjectDetails assigneeType(AssigneeTypeEnum assigneeType) {
    
    this.assigneeType = assigneeType;
    return this;
  }

   /**
   * The default assignee when creating issues for this project.
   * @return assigneeType
  **/
  @jakarta.annotation.Nullable

  public AssigneeTypeEnum getAssigneeType() {
    return assigneeType;
  }


  public void setAssigneeType(AssigneeTypeEnum assigneeType) {
    this.assigneeType = assigneeType;
  }


  public UpdateProjectDetails avatarId(Long avatarId) {
    
    this.avatarId = avatarId;
    return this;
  }

   /**
   * An integer value for the project&#39;s avatar.
   * @return avatarId
  **/
  @jakarta.annotation.Nullable

  public Long getAvatarId() {
    return avatarId;
  }


  public void setAvatarId(Long avatarId) {
    this.avatarId = avatarId;
  }


  public UpdateProjectDetails issueSecurityScheme(Long issueSecurityScheme) {
    
    this.issueSecurityScheme = issueSecurityScheme;
    return this;
  }

   /**
   * The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.
   * @return issueSecurityScheme
  **/
  @jakarta.annotation.Nullable

  public Long getIssueSecurityScheme() {
    return issueSecurityScheme;
  }


  public void setIssueSecurityScheme(Long issueSecurityScheme) {
    this.issueSecurityScheme = issueSecurityScheme;
  }


  public UpdateProjectDetails permissionScheme(Long permissionScheme) {
    
    this.permissionScheme = permissionScheme;
    return this;
  }

   /**
   * The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.
   * @return permissionScheme
  **/
  @jakarta.annotation.Nullable

  public Long getPermissionScheme() {
    return permissionScheme;
  }


  public void setPermissionScheme(Long permissionScheme) {
    this.permissionScheme = permissionScheme;
  }


  public UpdateProjectDetails notificationScheme(Long notificationScheme) {
    
    this.notificationScheme = notificationScheme;
    return this;
  }

   /**
   * The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.
   * @return notificationScheme
  **/
  @jakarta.annotation.Nullable

  public Long getNotificationScheme() {
    return notificationScheme;
  }


  public void setNotificationScheme(Long notificationScheme) {
    this.notificationScheme = notificationScheme;
  }


  public UpdateProjectDetails categoryId(Long categoryId) {
    
    this.categoryId = categoryId;
    return this;
  }

   /**
   * The ID of the project&#39;s category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation. To remove the project category from the project, set the value to &#x60;-1.&#x60;
   * @return categoryId
  **/
  @jakarta.annotation.Nullable

  public Long getCategoryId() {
    return categoryId;
  }


  public void setCategoryId(Long categoryId) {
    this.categoryId = categoryId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateProjectDetails updateProjectDetails = (UpdateProjectDetails) o;
    return Objects.equals(this.key, updateProjectDetails.key) &&
        Objects.equals(this.name, updateProjectDetails.name) &&
        Objects.equals(this.description, updateProjectDetails.description) &&
        Objects.equals(this.lead, updateProjectDetails.lead) &&
        Objects.equals(this.leadAccountId, updateProjectDetails.leadAccountId) &&
        Objects.equals(this.url, updateProjectDetails.url) &&
        Objects.equals(this.assigneeType, updateProjectDetails.assigneeType) &&
        Objects.equals(this.avatarId, updateProjectDetails.avatarId) &&
        Objects.equals(this.issueSecurityScheme, updateProjectDetails.issueSecurityScheme) &&
        Objects.equals(this.permissionScheme, updateProjectDetails.permissionScheme) &&
        Objects.equals(this.notificationScheme, updateProjectDetails.notificationScheme) &&
        Objects.equals(this.categoryId, updateProjectDetails.categoryId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, description, lead, leadAccountId, url, assigneeType, avatarId, issueSecurityScheme, permissionScheme, notificationScheme, categoryId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateProjectDetails {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    lead: ").append(toIndentedString(lead)).append("\n");
    sb.append("    leadAccountId: ").append(toIndentedString(leadAccountId)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    assigneeType: ").append(toIndentedString(assigneeType)).append("\n");
    sb.append("    avatarId: ").append(toIndentedString(avatarId)).append("\n");
    sb.append("    issueSecurityScheme: ").append(toIndentedString(issueSecurityScheme)).append("\n");
    sb.append("    permissionScheme: ").append(toIndentedString(permissionScheme)).append("\n");
    sb.append("    notificationScheme: ").append(toIndentedString(notificationScheme)).append("\n");
    sb.append("    categoryId: ").append(toIndentedString(categoryId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("key");
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("lead");
    openapiFields.add("leadAccountId");
    openapiFields.add("url");
    openapiFields.add("assigneeType");
    openapiFields.add("avatarId");
    openapiFields.add("issueSecurityScheme");
    openapiFields.add("permissionScheme");
    openapiFields.add("notificationScheme");
    openapiFields.add("categoryId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to UpdateProjectDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!UpdateProjectDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateProjectDetails is not found in the empty JSON string", UpdateProjectDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!UpdateProjectDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UpdateProjectDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("lead") != null && !jsonObj.get("lead").isJsonNull()) && !jsonObj.get("lead").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lead` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lead").toString()));
      }
      if ((jsonObj.get("leadAccountId") != null && !jsonObj.get("leadAccountId").isJsonNull()) && !jsonObj.get("leadAccountId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `leadAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("leadAccountId").toString()));
      }
      if ((jsonObj.get("url") != null && !jsonObj.get("url").isJsonNull()) && !jsonObj.get("url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
      if ((jsonObj.get("assigneeType") != null && !jsonObj.get("assigneeType").isJsonNull()) && !jsonObj.get("assigneeType").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `assigneeType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("assigneeType").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!UpdateProjectDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'UpdateProjectDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<UpdateProjectDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(UpdateProjectDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<UpdateProjectDetails>() {
           @Override
           public void write(JsonWriter out, UpdateProjectDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public UpdateProjectDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of UpdateProjectDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of UpdateProjectDetails
  * @throws IOException if the JSON string is invalid with respect to UpdateProjectDetails
  */
  public static UpdateProjectDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, UpdateProjectDetails.class);
  }

 /**
  * Convert an instance of UpdateProjectDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

