/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.User;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The details of votes on an issue.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Votes {
  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_VOTES = "votes";
  @SerializedName(SERIALIZED_NAME_VOTES)
  private Long votes;

  public static final String SERIALIZED_NAME_HAS_VOTED = "hasVoted";
  @SerializedName(SERIALIZED_NAME_HAS_VOTED)
  private Boolean hasVoted;

  public static final String SERIALIZED_NAME_VOTERS = "voters";
  @SerializedName(SERIALIZED_NAME_VOTERS)
  private List<User> voters = null;

  public Votes() {
  }

  
  public Votes(
     URI self, 
     Long votes, 
     Boolean hasVoted, 
     List<User> voters
  ) {
    this();
    this.self = self;
    this.votes = votes;
    this.hasVoted = hasVoted;
    this.voters = voters;
  }

   /**
   * The URL of these issue vote details.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




   /**
   * The number of votes on the issue.
   * @return votes
  **/
  @jakarta.annotation.Nullable

  public Long getVotes() {
    return votes;
  }




   /**
   * Whether the user making this request has voted on the issue.
   * @return hasVoted
  **/
  @jakarta.annotation.Nullable

  public Boolean getHasVoted() {
    return hasVoted;
  }




   /**
   * List of the users who have voted on this issue. An empty list is returned when the calling user doesn&#39;t have the *View voters and watchers* project permission.
   * @return voters
  **/
  @jakarta.annotation.Nullable

  public List<User> getVoters() {
    return voters;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Votes votes = (Votes) o;
    return Objects.equals(this.self, votes.self) &&
        Objects.equals(this.votes, votes.votes) &&
        Objects.equals(this.hasVoted, votes.hasVoted) &&
        Objects.equals(this.voters, votes.voters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(self, votes, hasVoted, voters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Votes {\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("    hasVoted: ").append(toIndentedString(hasVoted)).append("\n");
    sb.append("    voters: ").append(toIndentedString(voters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("self");
    openapiFields.add("votes");
    openapiFields.add("hasVoted");
    openapiFields.add("voters");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Votes
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Votes.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Votes is not found in the empty JSON string", Votes.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Votes.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Votes` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if (jsonObj.get("voters") != null && !jsonObj.get("voters").isJsonNull()) {
        JsonArray jsonArrayvoters = jsonObj.getAsJsonArray("voters");
        if (jsonArrayvoters != null) {
          // ensure the json data is an array
          if (!jsonObj.get("voters").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `voters` to be an array in the JSON string but got `%s`", jsonObj.get("voters").toString()));
          }

          // validate the optional field `voters` (array)
          for (int i = 0; i < jsonArrayvoters.size(); i++) {
            User.validateJsonObject(jsonArrayvoters.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Votes.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Votes' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Votes> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Votes.class));

       return (TypeAdapter<T>) new TypeAdapter<Votes>() {
           @Override
           public void write(JsonWriter out, Votes value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Votes read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Votes given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Votes
  * @throws IOException if the JSON string is invalid with respect to Votes
  */
  public static Votes fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Votes.class);
  }

 /**
  * Convert an instance of Votes to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

