/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.UserDetails;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The details of watchers on an issue.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Watchers {
  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private String self;

  public static final String SERIALIZED_NAME_IS_WATCHING = "isWatching";
  @SerializedName(SERIALIZED_NAME_IS_WATCHING)
  private Boolean isWatching;

  public static final String SERIALIZED_NAME_WATCH_COUNT = "watchCount";
  @SerializedName(SERIALIZED_NAME_WATCH_COUNT)
  private Integer watchCount;

  public static final String SERIALIZED_NAME_WATCHERS = "watchers";
  @SerializedName(SERIALIZED_NAME_WATCHERS)
  private List<UserDetails> watchers = null;

  public Watchers() {
  }

  
  public Watchers(
     String self, 
     Boolean isWatching, 
     Integer watchCount, 
     List<UserDetails> watchers
  ) {
    this();
    this.self = self;
    this.isWatching = isWatching;
    this.watchCount = watchCount;
    this.watchers = watchers;
  }

   /**
   * The URL of these issue watcher details.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public String getSelf() {
    return self;
  }




   /**
   * Whether the calling user is watching this issue.
   * @return isWatching
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsWatching() {
    return isWatching;
  }




   /**
   * The number of users watching this issue.
   * @return watchCount
  **/
  @jakarta.annotation.Nullable

  public Integer getWatchCount() {
    return watchCount;
  }




   /**
   * Details of the users watching this issue.
   * @return watchers
  **/
  @jakarta.annotation.Nullable

  public List<UserDetails> getWatchers() {
    return watchers;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Watchers watchers = (Watchers) o;
    return Objects.equals(this.self, watchers.self) &&
        Objects.equals(this.isWatching, watchers.isWatching) &&
        Objects.equals(this.watchCount, watchers.watchCount) &&
        Objects.equals(this.watchers, watchers.watchers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(self, isWatching, watchCount, watchers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Watchers {\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    isWatching: ").append(toIndentedString(isWatching)).append("\n");
    sb.append("    watchCount: ").append(toIndentedString(watchCount)).append("\n");
    sb.append("    watchers: ").append(toIndentedString(watchers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("self");
    openapiFields.add("isWatching");
    openapiFields.add("watchCount");
    openapiFields.add("watchers");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Watchers
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Watchers.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Watchers is not found in the empty JSON string", Watchers.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Watchers.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Watchers` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if (jsonObj.get("watchers") != null && !jsonObj.get("watchers").isJsonNull()) {
        JsonArray jsonArraywatchers = jsonObj.getAsJsonArray("watchers");
        if (jsonArraywatchers != null) {
          // ensure the json data is an array
          if (!jsonObj.get("watchers").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `watchers` to be an array in the JSON string but got `%s`", jsonObj.get("watchers").toString()));
          }

          // validate the optional field `watchers` (array)
          for (int i = 0; i < jsonArraywatchers.size(); i++) {
            UserDetails.validateJsonObject(jsonArraywatchers.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Watchers.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Watchers' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Watchers> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Watchers.class));

       return (TypeAdapter<T>) new TypeAdapter<Watchers>() {
           @Override
           public void write(JsonWriter out, Watchers value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Watchers read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Watchers given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Watchers
  * @throws IOException if the JSON string is invalid with respect to Watchers
  */
  public static Watchers fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Watchers.class);
  }

 /**
  * Convert an instance of Watchers to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

