/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A webhook.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Webhook {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_JQL_FILTER = "jqlFilter";
  @SerializedName(SERIALIZED_NAME_JQL_FILTER)
  private String jqlFilter;

  public static final String SERIALIZED_NAME_FIELD_IDS_FILTER = "fieldIdsFilter";
  @SerializedName(SERIALIZED_NAME_FIELD_IDS_FILTER)
  private List<String> fieldIdsFilter = null;

  public static final String SERIALIZED_NAME_ISSUE_PROPERTY_KEYS_FILTER = "issuePropertyKeysFilter";
  @SerializedName(SERIALIZED_NAME_ISSUE_PROPERTY_KEYS_FILTER)
  private List<String> issuePropertyKeysFilter = null;

  /**
   * Gets or Sets events
   */
  @JsonAdapter(EventsEnum.Adapter.class)
  public enum EventsEnum {
    JIRA_ISSUE_CREATED("jira:issue_created"),
    
    JIRA_ISSUE_UPDATED("jira:issue_updated"),
    
    JIRA_ISSUE_DELETED("jira:issue_deleted"),
    
    COMMENT_CREATED("comment_created"),
    
    COMMENT_UPDATED("comment_updated"),
    
    COMMENT_DELETED("comment_deleted"),
    
    ISSUE_PROPERTY_SET("issue_property_set"),
    
    ISSUE_PROPERTY_DELETED("issue_property_deleted");

    private String value;

    EventsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EventsEnum fromValue(String value) {
      for (EventsEnum b : EventsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EventsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EventsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EventsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EventsEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_EVENTS = "events";
  @SerializedName(SERIALIZED_NAME_EVENTS)
  private List<EventsEnum> events = new ArrayList<>();

  public static final String SERIALIZED_NAME_EXPIRATION_DATE = "expirationDate";
  @SerializedName(SERIALIZED_NAME_EXPIRATION_DATE)
  private Long expirationDate;

  public Webhook() {
  }

  
  public Webhook(
     Long expirationDate
  ) {
    this();
    this.expirationDate = expirationDate;
  }

  public Webhook id(Long id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the webhook.
   * @return id
  **/
  @jakarta.annotation.Nonnull

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }


  public Webhook jqlFilter(String jqlFilter) {
    
    this.jqlFilter = jqlFilter;
    return this;
  }

   /**
   * The JQL filter that specifies which issues the webhook is sent for.
   * @return jqlFilter
  **/
  @jakarta.annotation.Nonnull

  public String getJqlFilter() {
    return jqlFilter;
  }


  public void setJqlFilter(String jqlFilter) {
    this.jqlFilter = jqlFilter;
  }


  public Webhook fieldIdsFilter(List<String> fieldIdsFilter) {
    
    this.fieldIdsFilter = fieldIdsFilter;
    return this;
  }

  public Webhook addFieldIdsFilterItem(String fieldIdsFilterItem) {
    if (this.fieldIdsFilter == null) {
      this.fieldIdsFilter = new ArrayList<>();
    }
    this.fieldIdsFilter.add(fieldIdsFilterItem);
    return this;
  }

   /**
   * A list of field IDs. When the issue changelog contains any of the fields, the webhook &#x60;jira:issue_updated&#x60; is sent. If this parameter is not present, the app is notified about all field updates.
   * @return fieldIdsFilter
  **/
  @jakarta.annotation.Nullable

  public List<String> getFieldIdsFilter() {
    return fieldIdsFilter;
  }


  public void setFieldIdsFilter(List<String> fieldIdsFilter) {
    this.fieldIdsFilter = fieldIdsFilter;
  }


  public Webhook issuePropertyKeysFilter(List<String> issuePropertyKeysFilter) {
    
    this.issuePropertyKeysFilter = issuePropertyKeysFilter;
    return this;
  }

  public Webhook addIssuePropertyKeysFilterItem(String issuePropertyKeysFilterItem) {
    if (this.issuePropertyKeysFilter == null) {
      this.issuePropertyKeysFilter = new ArrayList<>();
    }
    this.issuePropertyKeysFilter.add(issuePropertyKeysFilterItem);
    return this;
  }

   /**
   * A list of issue property keys. A change of those issue properties triggers the &#x60;issue_property_set&#x60; or &#x60;issue_property_deleted&#x60; webhooks. If this parameter is not present, the app is notified about all issue property updates.
   * @return issuePropertyKeysFilter
  **/
  @jakarta.annotation.Nullable

  public List<String> getIssuePropertyKeysFilter() {
    return issuePropertyKeysFilter;
  }


  public void setIssuePropertyKeysFilter(List<String> issuePropertyKeysFilter) {
    this.issuePropertyKeysFilter = issuePropertyKeysFilter;
  }


  public Webhook events(List<EventsEnum> events) {
    
    this.events = events;
    return this;
  }

  public Webhook addEventsItem(EventsEnum eventsItem) {
    this.events.add(eventsItem);
    return this;
  }

   /**
   * The Jira events that trigger the webhook.
   * @return events
  **/
  @jakarta.annotation.Nonnull

  public List<EventsEnum> getEvents() {
    return events;
  }


  public void setEvents(List<EventsEnum> events) {
    this.events = events;
  }


   /**
   * The date after which the webhook is no longer sent. Use [Extend webhook life](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-webhooks/#api-rest-api-3-webhook-refresh-put) to extend the date.
   * @return expirationDate
  **/
  @jakarta.annotation.Nullable

  public Long getExpirationDate() {
    return expirationDate;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Webhook webhook = (Webhook) o;
    return Objects.equals(this.id, webhook.id) &&
        Objects.equals(this.jqlFilter, webhook.jqlFilter) &&
        Objects.equals(this.fieldIdsFilter, webhook.fieldIdsFilter) &&
        Objects.equals(this.issuePropertyKeysFilter, webhook.issuePropertyKeysFilter) &&
        Objects.equals(this.events, webhook.events) &&
        Objects.equals(this.expirationDate, webhook.expirationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, jqlFilter, fieldIdsFilter, issuePropertyKeysFilter, events, expirationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Webhook {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    jqlFilter: ").append(toIndentedString(jqlFilter)).append("\n");
    sb.append("    fieldIdsFilter: ").append(toIndentedString(fieldIdsFilter)).append("\n");
    sb.append("    issuePropertyKeysFilter: ").append(toIndentedString(issuePropertyKeysFilter)).append("\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("jqlFilter");
    openapiFields.add("fieldIdsFilter");
    openapiFields.add("issuePropertyKeysFilter");
    openapiFields.add("events");
    openapiFields.add("expirationDate");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("jqlFilter");
    openapiRequiredFields.add("events");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Webhook
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Webhook.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Webhook is not found in the empty JSON string", Webhook.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Webhook.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Webhook` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Webhook.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("jqlFilter").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `jqlFilter` to be a primitive type in the JSON string but got `%s`", jsonObj.get("jqlFilter").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("fieldIdsFilter") != null && !jsonObj.get("fieldIdsFilter").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `fieldIdsFilter` to be an array in the JSON string but got `%s`", jsonObj.get("fieldIdsFilter").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("issuePropertyKeysFilter") != null && !jsonObj.get("issuePropertyKeysFilter").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issuePropertyKeysFilter` to be an array in the JSON string but got `%s`", jsonObj.get("issuePropertyKeysFilter").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("events") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("events").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `events` to be an array in the JSON string but got `%s`", jsonObj.get("events").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Webhook.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Webhook' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Webhook> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Webhook.class));

       return (TypeAdapter<T>) new TypeAdapter<Webhook>() {
           @Override
           public void write(JsonWriter out, Webhook value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Webhook read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Webhook given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Webhook
  * @throws IOException if the JSON string is invalid with respect to Webhook
  */
  public static Webhook fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Webhook.class);
  }

 /**
  * Convert an instance of Webhook to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

