/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.ProjectDetails;
import software.tnb.jira.validation.generated.model.PublishedWorkflowId;
import software.tnb.jira.validation.generated.model.Transition;
import software.tnb.jira.validation.generated.model.WorkflowOperations;
import software.tnb.jira.validation.generated.model.WorkflowSchemeIdName;
import software.tnb.jira.validation.generated.model.WorkflowStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about a workflow.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Workflow {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private PublishedWorkflowId id;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_TRANSITIONS = "transitions";
  @SerializedName(SERIALIZED_NAME_TRANSITIONS)
  private List<Transition> transitions = null;

  public static final String SERIALIZED_NAME_STATUSES = "statuses";
  @SerializedName(SERIALIZED_NAME_STATUSES)
  private List<WorkflowStatus> statuses = null;

  public static final String SERIALIZED_NAME_IS_DEFAULT = "isDefault";
  @SerializedName(SERIALIZED_NAME_IS_DEFAULT)
  private Boolean isDefault;

  public static final String SERIALIZED_NAME_SCHEMES = "schemes";
  @SerializedName(SERIALIZED_NAME_SCHEMES)
  private List<WorkflowSchemeIdName> schemes = null;

  public static final String SERIALIZED_NAME_PROJECTS = "projects";
  @SerializedName(SERIALIZED_NAME_PROJECTS)
  private List<ProjectDetails> projects = null;

  public static final String SERIALIZED_NAME_HAS_DRAFT_WORKFLOW = "hasDraftWorkflow";
  @SerializedName(SERIALIZED_NAME_HAS_DRAFT_WORKFLOW)
  private Boolean hasDraftWorkflow;

  public static final String SERIALIZED_NAME_OPERATIONS = "operations";
  @SerializedName(SERIALIZED_NAME_OPERATIONS)
  private WorkflowOperations operations;

  public static final String SERIALIZED_NAME_CREATED = "created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private String created;

  public static final String SERIALIZED_NAME_UPDATED = "updated";
  @SerializedName(SERIALIZED_NAME_UPDATED)
  private String updated;

  public Workflow() {
  }

  public Workflow id(PublishedWorkflowId id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nonnull

  public PublishedWorkflowId getId() {
    return id;
  }


  public void setId(PublishedWorkflowId id) {
    this.id = id;
  }


  public Workflow description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the workflow.
   * @return description
  **/
  @jakarta.annotation.Nonnull

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public Workflow transitions(List<Transition> transitions) {
    
    this.transitions = transitions;
    return this;
  }

  public Workflow addTransitionsItem(Transition transitionsItem) {
    if (this.transitions == null) {
      this.transitions = new ArrayList<>();
    }
    this.transitions.add(transitionsItem);
    return this;
  }

   /**
   * The transitions of the workflow.
   * @return transitions
  **/
  @jakarta.annotation.Nullable

  public List<Transition> getTransitions() {
    return transitions;
  }


  public void setTransitions(List<Transition> transitions) {
    this.transitions = transitions;
  }


  public Workflow statuses(List<WorkflowStatus> statuses) {
    
    this.statuses = statuses;
    return this;
  }

  public Workflow addStatusesItem(WorkflowStatus statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * The statuses of the workflow.
   * @return statuses
  **/
  @jakarta.annotation.Nullable

  public List<WorkflowStatus> getStatuses() {
    return statuses;
  }


  public void setStatuses(List<WorkflowStatus> statuses) {
    this.statuses = statuses;
  }


  public Workflow isDefault(Boolean isDefault) {
    
    this.isDefault = isDefault;
    return this;
  }

   /**
   * Whether this is the default workflow.
   * @return isDefault
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsDefault() {
    return isDefault;
  }


  public void setIsDefault(Boolean isDefault) {
    this.isDefault = isDefault;
  }


  public Workflow schemes(List<WorkflowSchemeIdName> schemes) {
    
    this.schemes = schemes;
    return this;
  }

  public Workflow addSchemesItem(WorkflowSchemeIdName schemesItem) {
    if (this.schemes == null) {
      this.schemes = new ArrayList<>();
    }
    this.schemes.add(schemesItem);
    return this;
  }

   /**
   * The workflow schemes the workflow is assigned to.
   * @return schemes
  **/
  @jakarta.annotation.Nullable

  public List<WorkflowSchemeIdName> getSchemes() {
    return schemes;
  }


  public void setSchemes(List<WorkflowSchemeIdName> schemes) {
    this.schemes = schemes;
  }


  public Workflow projects(List<ProjectDetails> projects) {
    
    this.projects = projects;
    return this;
  }

  public Workflow addProjectsItem(ProjectDetails projectsItem) {
    if (this.projects == null) {
      this.projects = new ArrayList<>();
    }
    this.projects.add(projectsItem);
    return this;
  }

   /**
   * The projects the workflow is assigned to, through workflow schemes.
   * @return projects
  **/
  @jakarta.annotation.Nullable

  public List<ProjectDetails> getProjects() {
    return projects;
  }


  public void setProjects(List<ProjectDetails> projects) {
    this.projects = projects;
  }


  public Workflow hasDraftWorkflow(Boolean hasDraftWorkflow) {
    
    this.hasDraftWorkflow = hasDraftWorkflow;
    return this;
  }

   /**
   * Whether the workflow has a draft version.
   * @return hasDraftWorkflow
  **/
  @jakarta.annotation.Nullable

  public Boolean getHasDraftWorkflow() {
    return hasDraftWorkflow;
  }


  public void setHasDraftWorkflow(Boolean hasDraftWorkflow) {
    this.hasDraftWorkflow = hasDraftWorkflow;
  }


  public Workflow operations(WorkflowOperations operations) {
    
    this.operations = operations;
    return this;
  }

   /**
   * Get operations
   * @return operations
  **/
  @jakarta.annotation.Nullable

  public WorkflowOperations getOperations() {
    return operations;
  }


  public void setOperations(WorkflowOperations operations) {
    this.operations = operations;
  }


  public Workflow created(String created) {
    
    this.created = created;
    return this;
  }

   /**
   * The creation date of the workflow.
   * @return created
  **/
  @jakarta.annotation.Nullable

  public String getCreated() {
    return created;
  }


  public void setCreated(String created) {
    this.created = created;
  }


  public Workflow updated(String updated) {
    
    this.updated = updated;
    return this;
  }

   /**
   * The last edited date of the workflow.
   * @return updated
  **/
  @jakarta.annotation.Nullable

  public String getUpdated() {
    return updated;
  }


  public void setUpdated(String updated) {
    this.updated = updated;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Workflow workflow = (Workflow) o;
    return Objects.equals(this.id, workflow.id) &&
        Objects.equals(this.description, workflow.description) &&
        Objects.equals(this.transitions, workflow.transitions) &&
        Objects.equals(this.statuses, workflow.statuses) &&
        Objects.equals(this.isDefault, workflow.isDefault) &&
        Objects.equals(this.schemes, workflow.schemes) &&
        Objects.equals(this.projects, workflow.projects) &&
        Objects.equals(this.hasDraftWorkflow, workflow.hasDraftWorkflow) &&
        Objects.equals(this.operations, workflow.operations) &&
        Objects.equals(this.created, workflow.created) &&
        Objects.equals(this.updated, workflow.updated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, description, transitions, statuses, isDefault, schemes, projects, hasDraftWorkflow, operations, created, updated);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Workflow {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    isDefault: ").append(toIndentedString(isDefault)).append("\n");
    sb.append("    schemes: ").append(toIndentedString(schemes)).append("\n");
    sb.append("    projects: ").append(toIndentedString(projects)).append("\n");
    sb.append("    hasDraftWorkflow: ").append(toIndentedString(hasDraftWorkflow)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("description");
    openapiFields.add("transitions");
    openapiFields.add("statuses");
    openapiFields.add("isDefault");
    openapiFields.add("schemes");
    openapiFields.add("projects");
    openapiFields.add("hasDraftWorkflow");
    openapiFields.add("operations");
    openapiFields.add("created");
    openapiFields.add("updated");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("description");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Workflow
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Workflow.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Workflow is not found in the empty JSON string", Workflow.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Workflow.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Workflow` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Workflow.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the required field `id`
      PublishedWorkflowId.validateJsonObject(jsonObj.getAsJsonObject("id"));
      if (!jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("transitions") != null && !jsonObj.get("transitions").isJsonNull()) {
        JsonArray jsonArraytransitions = jsonObj.getAsJsonArray("transitions");
        if (jsonArraytransitions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("transitions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `transitions` to be an array in the JSON string but got `%s`", jsonObj.get("transitions").toString()));
          }

          // validate the optional field `transitions` (array)
          for (int i = 0; i < jsonArraytransitions.size(); i++) {
            Transition.validateJsonObject(jsonArraytransitions.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("statuses") != null && !jsonObj.get("statuses").isJsonNull()) {
        JsonArray jsonArraystatuses = jsonObj.getAsJsonArray("statuses");
        if (jsonArraystatuses != null) {
          // ensure the json data is an array
          if (!jsonObj.get("statuses").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `statuses` to be an array in the JSON string but got `%s`", jsonObj.get("statuses").toString()));
          }

          // validate the optional field `statuses` (array)
          for (int i = 0; i < jsonArraystatuses.size(); i++) {
            WorkflowStatus.validateJsonObject(jsonArraystatuses.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("schemes") != null && !jsonObj.get("schemes").isJsonNull()) {
        JsonArray jsonArrayschemes = jsonObj.getAsJsonArray("schemes");
        if (jsonArrayschemes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("schemes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `schemes` to be an array in the JSON string but got `%s`", jsonObj.get("schemes").toString()));
          }

          // validate the optional field `schemes` (array)
          for (int i = 0; i < jsonArrayschemes.size(); i++) {
            WorkflowSchemeIdName.validateJsonObject(jsonArrayschemes.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("projects") != null && !jsonObj.get("projects").isJsonNull()) {
        JsonArray jsonArrayprojects = jsonObj.getAsJsonArray("projects");
        if (jsonArrayprojects != null) {
          // ensure the json data is an array
          if (!jsonObj.get("projects").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `projects` to be an array in the JSON string but got `%s`", jsonObj.get("projects").toString()));
          }

          // validate the optional field `projects` (array)
          for (int i = 0; i < jsonArrayprojects.size(); i++) {
            ProjectDetails.validateJsonObject(jsonArrayprojects.get(i).getAsJsonObject());
          };
        }
      }
      // validate the optional field `operations`
      if (jsonObj.get("operations") != null && !jsonObj.get("operations").isJsonNull()) {
        WorkflowOperations.validateJsonObject(jsonObj.getAsJsonObject("operations"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Workflow.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Workflow' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Workflow> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Workflow.class));

       return (TypeAdapter<T>) new TypeAdapter<Workflow>() {
           @Override
           public void write(JsonWriter out, Workflow value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Workflow read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Workflow given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Workflow
  * @throws IOException if the JSON string is invalid with respect to Workflow
  */
  public static Workflow fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Workflow.class);
  }

 /**
  * Convert an instance of Workflow to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

