/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import software.tnb.jira.validation.generated.model.WorkflowTransitionRules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of workflow transition rules.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class WorkflowRulesSearchDetails {
  public static final String SERIALIZED_NAME_WORKFLOW_ENTITY_ID = "workflowEntityId";
  @SerializedName(SERIALIZED_NAME_WORKFLOW_ENTITY_ID)
  private UUID workflowEntityId;

  public static final String SERIALIZED_NAME_INVALID_RULES = "invalidRules";
  @SerializedName(SERIALIZED_NAME_INVALID_RULES)
  private List<UUID> invalidRules = null;

  public static final String SERIALIZED_NAME_VALID_RULES = "validRules";
  @SerializedName(SERIALIZED_NAME_VALID_RULES)
  private List<WorkflowTransitionRules> validRules = null;

  public WorkflowRulesSearchDetails() {
  }

  public WorkflowRulesSearchDetails workflowEntityId(UUID workflowEntityId) {
    
    this.workflowEntityId = workflowEntityId;
    return this;
  }

   /**
   * The workflow ID.
   * @return workflowEntityId
  **/
  @jakarta.annotation.Nullable

  public UUID getWorkflowEntityId() {
    return workflowEntityId;
  }


  public void setWorkflowEntityId(UUID workflowEntityId) {
    this.workflowEntityId = workflowEntityId;
  }


  public WorkflowRulesSearchDetails invalidRules(List<UUID> invalidRules) {
    
    this.invalidRules = invalidRules;
    return this;
  }

  public WorkflowRulesSearchDetails addInvalidRulesItem(UUID invalidRulesItem) {
    if (this.invalidRules == null) {
      this.invalidRules = new ArrayList<>();
    }
    this.invalidRules.add(invalidRulesItem);
    return this;
  }

   /**
   * List of workflow rule IDs that do not belong to the workflow or can not be found.
   * @return invalidRules
  **/
  @jakarta.annotation.Nullable

  public List<UUID> getInvalidRules() {
    return invalidRules;
  }


  public void setInvalidRules(List<UUID> invalidRules) {
    this.invalidRules = invalidRules;
  }


  public WorkflowRulesSearchDetails validRules(List<WorkflowTransitionRules> validRules) {
    
    this.validRules = validRules;
    return this;
  }

  public WorkflowRulesSearchDetails addValidRulesItem(WorkflowTransitionRules validRulesItem) {
    if (this.validRules == null) {
      this.validRules = new ArrayList<>();
    }
    this.validRules.add(validRulesItem);
    return this;
  }

   /**
   * List of valid workflow transition rules.
   * @return validRules
  **/
  @jakarta.annotation.Nullable

  public List<WorkflowTransitionRules> getValidRules() {
    return validRules;
  }


  public void setValidRules(List<WorkflowTransitionRules> validRules) {
    this.validRules = validRules;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowRulesSearchDetails workflowRulesSearchDetails = (WorkflowRulesSearchDetails) o;
    return Objects.equals(this.workflowEntityId, workflowRulesSearchDetails.workflowEntityId) &&
        Objects.equals(this.invalidRules, workflowRulesSearchDetails.invalidRules) &&
        Objects.equals(this.validRules, workflowRulesSearchDetails.validRules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(workflowEntityId, invalidRules, validRules);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowRulesSearchDetails {\n");
    sb.append("    workflowEntityId: ").append(toIndentedString(workflowEntityId)).append("\n");
    sb.append("    invalidRules: ").append(toIndentedString(invalidRules)).append("\n");
    sb.append("    validRules: ").append(toIndentedString(validRules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("workflowEntityId");
    openapiFields.add("invalidRules");
    openapiFields.add("validRules");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WorkflowRulesSearchDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!WorkflowRulesSearchDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in WorkflowRulesSearchDetails is not found in the empty JSON string", WorkflowRulesSearchDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!WorkflowRulesSearchDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `WorkflowRulesSearchDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("workflowEntityId") != null && !jsonObj.get("workflowEntityId").isJsonNull()) && !jsonObj.get("workflowEntityId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `workflowEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("workflowEntityId").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("invalidRules") != null && !jsonObj.get("invalidRules").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `invalidRules` to be an array in the JSON string but got `%s`", jsonObj.get("invalidRules").toString()));
      }
      if (jsonObj.get("validRules") != null && !jsonObj.get("validRules").isJsonNull()) {
        JsonArray jsonArrayvalidRules = jsonObj.getAsJsonArray("validRules");
        if (jsonArrayvalidRules != null) {
          // ensure the json data is an array
          if (!jsonObj.get("validRules").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `validRules` to be an array in the JSON string but got `%s`", jsonObj.get("validRules").toString()));
          }

          // validate the optional field `validRules` (array)
          for (int i = 0; i < jsonArrayvalidRules.size(); i++) {
            WorkflowTransitionRules.validateJsonObject(jsonArrayvalidRules.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WorkflowRulesSearchDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WorkflowRulesSearchDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WorkflowRulesSearchDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WorkflowRulesSearchDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<WorkflowRulesSearchDetails>() {
           @Override
           public void write(JsonWriter out, WorkflowRulesSearchDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public WorkflowRulesSearchDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WorkflowRulesSearchDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WorkflowRulesSearchDetails
  * @throws IOException if the JSON string is invalid with respect to WorkflowRulesSearchDetails
  */
  public static WorkflowRulesSearchDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WorkflowRulesSearchDetails.class);
  }

 /**
  * Convert an instance of WorkflowRulesSearchDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

