/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.EntityProperty;
import software.tnb.jira.validation.generated.model.WorklogAuthor;
import software.tnb.jira.validation.generated.model.WorklogUpdateAuthor;
import software.tnb.jira.validation.generated.model.WorklogVisibility;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of a worklog.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Worklog {
  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_AUTHOR = "author";
  @SerializedName(SERIALIZED_NAME_AUTHOR)
  private WorklogAuthor author;

  public static final String SERIALIZED_NAME_UPDATE_AUTHOR = "updateAuthor";
  @SerializedName(SERIALIZED_NAME_UPDATE_AUTHOR)
  private WorklogUpdateAuthor updateAuthor;

  public static final String SERIALIZED_NAME_COMMENT = "comment";
  @SerializedName(SERIALIZED_NAME_COMMENT)
  private Object comment = null;

  public static final String SERIALIZED_NAME_CREATED = "created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private String created;

  public static final String SERIALIZED_NAME_UPDATED = "updated";
  @SerializedName(SERIALIZED_NAME_UPDATED)
  private String updated;

  public static final String SERIALIZED_NAME_VISIBILITY = "visibility";
  @SerializedName(SERIALIZED_NAME_VISIBILITY)
  private WorklogVisibility visibility;

  public static final String SERIALIZED_NAME_STARTED = "started";
  @SerializedName(SERIALIZED_NAME_STARTED)
  private String started;

  public static final String SERIALIZED_NAME_TIME_SPENT = "timeSpent";
  @SerializedName(SERIALIZED_NAME_TIME_SPENT)
  private String timeSpent;

  public static final String SERIALIZED_NAME_TIME_SPENT_SECONDS = "timeSpentSeconds";
  @SerializedName(SERIALIZED_NAME_TIME_SPENT_SECONDS)
  private Long timeSpentSeconds;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ISSUE_ID = "issueId";
  @SerializedName(SERIALIZED_NAME_ISSUE_ID)
  private String issueId;

  public static final String SERIALIZED_NAME_PROPERTIES = "properties";
  @SerializedName(SERIALIZED_NAME_PROPERTIES)
  private List<EntityProperty> properties = null;

  public Worklog() {
  }

  
  public Worklog(
     URI self, 
     String created, 
     String updated, 
     String id, 
     String issueId
  ) {
    this();
    this.self = self;
    this.created = created;
    this.updated = updated;
    this.id = id;
    this.issueId = issueId;
  }

   /**
   * The URL of the worklog item.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




  public Worklog author(WorklogAuthor author) {
    
    this.author = author;
    return this;
  }

   /**
   * Get author
   * @return author
  **/
  @jakarta.annotation.Nullable

  public WorklogAuthor getAuthor() {
    return author;
  }


  public void setAuthor(WorklogAuthor author) {
    this.author = author;
  }


  public Worklog updateAuthor(WorklogUpdateAuthor updateAuthor) {
    
    this.updateAuthor = updateAuthor;
    return this;
  }

   /**
   * Get updateAuthor
   * @return updateAuthor
  **/
  @jakarta.annotation.Nullable

  public WorklogUpdateAuthor getUpdateAuthor() {
    return updateAuthor;
  }


  public void setUpdateAuthor(WorklogUpdateAuthor updateAuthor) {
    this.updateAuthor = updateAuthor;
  }


  public Worklog comment(Object comment) {
    
    this.comment = comment;
    return this;
  }

   /**
   * A comment about the worklog in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/). Optional when creating or updating a worklog.
   * @return comment
  **/
  @jakarta.annotation.Nullable

  public Object getComment() {
    return comment;
  }


  public void setComment(Object comment) {
    this.comment = comment;
  }


   /**
   * The datetime on which the worklog was created.
   * @return created
  **/
  @jakarta.annotation.Nullable

  public String getCreated() {
    return created;
  }




   /**
   * The datetime on which the worklog was last updated.
   * @return updated
  **/
  @jakarta.annotation.Nullable

  public String getUpdated() {
    return updated;
  }




  public Worklog visibility(WorklogVisibility visibility) {
    
    this.visibility = visibility;
    return this;
  }

   /**
   * Get visibility
   * @return visibility
  **/
  @jakarta.annotation.Nullable

  public WorklogVisibility getVisibility() {
    return visibility;
  }


  public void setVisibility(WorklogVisibility visibility) {
    this.visibility = visibility;
  }


  public Worklog started(String started) {
    
    this.started = started;
    return this;
  }

   /**
   * The datetime on which the worklog effort was started. Required when creating a worklog. Optional when updating a worklog.
   * @return started
  **/
  @jakarta.annotation.Nullable

  public String getStarted() {
    return started;
  }


  public void setStarted(String started) {
    this.started = started;
  }


  public Worklog timeSpent(String timeSpent) {
    
    this.timeSpent = timeSpent;
    return this;
  }

   /**
   * The time spent working on the issue as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). Required when creating a worklog if &#x60;timeSpentSeconds&#x60; isn&#39;t provided. Optional when updating a worklog. Cannot be provided if &#x60;timeSpentSecond&#x60; is provided.
   * @return timeSpent
  **/
  @jakarta.annotation.Nullable

  public String getTimeSpent() {
    return timeSpent;
  }


  public void setTimeSpent(String timeSpent) {
    this.timeSpent = timeSpent;
  }


  public Worklog timeSpentSeconds(Long timeSpentSeconds) {
    
    this.timeSpentSeconds = timeSpentSeconds;
    return this;
  }

   /**
   * The time in seconds spent working on the issue. Required when creating a worklog if &#x60;timeSpent&#x60; isn&#39;t provided. Optional when updating a worklog. Cannot be provided if &#x60;timeSpent&#x60; is provided.
   * @return timeSpentSeconds
  **/
  @jakarta.annotation.Nullable

  public Long getTimeSpentSeconds() {
    return timeSpentSeconds;
  }


  public void setTimeSpentSeconds(Long timeSpentSeconds) {
    this.timeSpentSeconds = timeSpentSeconds;
  }


   /**
   * The ID of the worklog record.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




   /**
   * The ID of the issue this worklog is for.
   * @return issueId
  **/
  @jakarta.annotation.Nullable

  public String getIssueId() {
    return issueId;
  }




  public Worklog properties(List<EntityProperty> properties) {
    
    this.properties = properties;
    return this;
  }

  public Worklog addPropertiesItem(EntityProperty propertiesItem) {
    if (this.properties == null) {
      this.properties = new ArrayList<>();
    }
    this.properties.add(propertiesItem);
    return this;
  }

   /**
   * Details of properties for the worklog. Optional when creating or updating a worklog.
   * @return properties
  **/
  @jakarta.annotation.Nullable

  public List<EntityProperty> getProperties() {
    return properties;
  }


  public void setProperties(List<EntityProperty> properties) {
    this.properties = properties;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the Worklog instance itself
   */
  public Worklog putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Worklog worklog = (Worklog) o;
    return Objects.equals(this.self, worklog.self) &&
        Objects.equals(this.author, worklog.author) &&
        Objects.equals(this.updateAuthor, worklog.updateAuthor) &&
        Objects.equals(this.comment, worklog.comment) &&
        Objects.equals(this.created, worklog.created) &&
        Objects.equals(this.updated, worklog.updated) &&
        Objects.equals(this.visibility, worklog.visibility) &&
        Objects.equals(this.started, worklog.started) &&
        Objects.equals(this.timeSpent, worklog.timeSpent) &&
        Objects.equals(this.timeSpentSeconds, worklog.timeSpentSeconds) &&
        Objects.equals(this.id, worklog.id) &&
        Objects.equals(this.issueId, worklog.issueId) &&
        Objects.equals(this.properties, worklog.properties)&&
        Objects.equals(this.additionalProperties, worklog.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(self, author, updateAuthor, comment, created, updated, visibility, started, timeSpent, timeSpentSeconds, id, issueId, properties, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Worklog {\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    updateAuthor: ").append(toIndentedString(updateAuthor)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("    started: ").append(toIndentedString(started)).append("\n");
    sb.append("    timeSpent: ").append(toIndentedString(timeSpent)).append("\n");
    sb.append("    timeSpentSeconds: ").append(toIndentedString(timeSpentSeconds)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    issueId: ").append(toIndentedString(issueId)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("self");
    openapiFields.add("author");
    openapiFields.add("updateAuthor");
    openapiFields.add("comment");
    openapiFields.add("created");
    openapiFields.add("updated");
    openapiFields.add("visibility");
    openapiFields.add("started");
    openapiFields.add("timeSpent");
    openapiFields.add("timeSpentSeconds");
    openapiFields.add("id");
    openapiFields.add("issueId");
    openapiFields.add("properties");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Worklog
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Worklog.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Worklog is not found in the empty JSON string", Worklog.openapiRequiredFields.toString()));
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      // validate the optional field `author`
      if (jsonObj.get("author") != null && !jsonObj.get("author").isJsonNull()) {
        WorklogAuthor.validateJsonObject(jsonObj.getAsJsonObject("author"));
      }
      // validate the optional field `updateAuthor`
      if (jsonObj.get("updateAuthor") != null && !jsonObj.get("updateAuthor").isJsonNull()) {
        WorklogUpdateAuthor.validateJsonObject(jsonObj.getAsJsonObject("updateAuthor"));
      }
      // validate the optional field `visibility`
      if (jsonObj.get("visibility") != null && !jsonObj.get("visibility").isJsonNull()) {
        WorklogVisibility.validateJsonObject(jsonObj.getAsJsonObject("visibility"));
      }
      if ((jsonObj.get("timeSpent") != null && !jsonObj.get("timeSpent").isJsonNull()) && !jsonObj.get("timeSpent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `timeSpent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timeSpent").toString()));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("issueId") != null && !jsonObj.get("issueId").isJsonNull()) && !jsonObj.get("issueId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issueId").toString()));
      }
      if (jsonObj.get("properties") != null && !jsonObj.get("properties").isJsonNull()) {
        JsonArray jsonArrayproperties = jsonObj.getAsJsonArray("properties");
        if (jsonArrayproperties != null) {
          // ensure the json data is an array
          if (!jsonObj.get("properties").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `properties` to be an array in the JSON string but got `%s`", jsonObj.get("properties").toString()));
          }

          // validate the optional field `properties` (array)
          for (int i = 0; i < jsonArrayproperties.size(); i++) {
            EntityProperty.validateJsonObject(jsonArrayproperties.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Worklog.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Worklog' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Worklog> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Worklog.class));

       return (TypeAdapter<T>) new TypeAdapter<Worklog>() {
           @Override
           public void write(JsonWriter out, Worklog value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additional properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public Worklog read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             Worklog instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Worklog given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Worklog
  * @throws IOException if the JSON string is invalid with respect to Worklog
  */
  public static Worklog fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Worklog.class);
  }

 /**
  * Convert an instance of Worklog to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

