/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.mariadb.resource.openshift;

import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.function.Predicate;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.db.common.openshift.OpenshiftDB;
import software.tnb.db.common.service.SQL;
import software.tnb.db.mariadb.service.MariaDB;

@AutoService(value={MariaDB.class})
public class OpenshiftMariaDB
extends MariaDB
implements OpenshiftDeployable,
WithName,
WithInClusterHostname {
    private final OpenshiftDB openshiftDb = new OpenshiftDB((SQL)this, 3306);

    public void create() {
        this.openshiftDb.create();
    }

    public void undeploy() {
        this.openshiftDb.undeploy();
    }

    public void openResources() {
        this.openshiftDb.openResources();
    }

    public void closeResources() {
        this.openshiftDb.closeResources();
        this.validation = null;
    }

    public boolean isReady() {
        return this.openshiftDb.isReady();
    }

    public boolean isDeployed() {
        return this.openshiftDb.isDeployed();
    }

    public Predicate<Pod> podSelector() {
        return this.openshiftDb.podSelector();
    }

    public String hostname() {
        return this.inClusterHostname();
    }

    public int port() {
        return 3306;
    }

    public int localPort() {
        return this.openshiftDb.localPort();
    }

    public String name() {
        return "mariadb-tnb";
    }
}

