/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.postgres.service;

import java.util.Map;
import software.tnb.db.common.account.SQLAccount;
import software.tnb.db.common.service.SQL;
import software.tnb.db.postgres.account.PostgreSQLAccount;

public abstract class PostgreSQL
extends SQL {
    protected static final int PORT = 5432;

    public String defaultImage() {
        return "registry.redhat.io/rhel8/postgresql-13:latest";
    }

    protected Class<? extends SQLAccount> accountClass() {
        return PostgreSQLAccount.class;
    }

    public String jdbcConnectionUrl() {
        return String.format("jdbc:postgresql://%s:%d/%s", this.hostname(), this.port(), this.account().database());
    }

    public Map<String, String> containerEnvironment() {
        return Map.of("POSTGRESQL_DATABASE", this.account().database(), "POSTGRESQL_USER", this.account().username(), "POSTGRESQL_PASSWORD", this.account().password());
    }
}

