/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.prometheus.metrics.resource.local;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.prometheus.metrics.resource.local.PrometheusContainer;
import software.tnb.prometheus.metrics.service.PrometheusMetrics;

@AutoService(value={PrometheusMetrics.class})
public class LocalPrometheusMetrics
extends PrometheusMetrics
implements Deployable,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalPrometheusMetrics.class);
    private PrometheusContainer container;

    @Override
    public String getUrl() {
        if (this.container == null) {
            this.deploy();
        }
        return String.format("http://%s:%d", this.container.getHost(), this.container.getPort());
    }

    public String defaultImage() {
        return "quay.io/prometheus/prometheus";
    }

    public void deploy() {
        if (this.container == null) {
            LOG.info("Starting Prometheus container");
            this.container = new PrometheusContainer(this.image(), this.env());
            this.container.start();
            LOG.info("Prometheus container started");
        }
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping Prometheus container");
            this.container.stop();
        }
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public Map<String, String> env() {
        HashMap<String, String> env = new HashMap<String, String>();
        return env;
    }
}

