/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.prometheus.metrics.resource.openshift;

import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Route;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.prometheus.metrics.service.PrometheusMetrics;
import software.tnb.prometheus.metrics.validation.PrometheusMetricsValidation;

@AutoService(value={PrometheusMetrics.class})
public class OpenshiftPrometheusMetrics
extends PrometheusMetrics
implements OpenshiftDeployable {
    private static final String OPENSHIFT_MONITORING_NS = "openshift-monitoring";
    private static final String THANOS_OCP_NAME = "thanos-querier";
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetrics.class);

    public void beforeAll(ExtensionContext context) throws Exception {
        Route route = (Route)((Resource)OpenshiftClient.get().inNamespace(OPENSHIFT_MONITORING_NS).routes().withName(THANOS_OCP_NAME)).get();
        String url = "https://" + route.getSpec().getHost();
        String token = OpenshiftClient.get().getOauthToken();
        LOG.info("Prometheus url: {}", (Object)url);
        this.validation = new PrometheusMetricsValidation(url, token, OpenshiftClient.get().getNamespace());
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }

    public boolean isDeployed() {
        return true;
    }

    public Predicate<Pod> podSelector() {
        return null;
    }

    public void undeploy() {
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public void create() {
    }

    public boolean isReady() {
        return true;
    }

    @Override
    public String getUrl() {
        if (this.validation == null) {
            try {
                this.beforeAll(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ((PrometheusMetricsValidation)this.validation).getUrl();
    }
}

