/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.salesforce.service;

import com.force.api.ApiConfig;
import com.force.api.ForceApi;
import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.service.Service;
import software.tnb.common.utils.WaitUtils;
import software.tnb.salesforce.account.SalesforceAccount;
import software.tnb.salesforce.validation.SalesforceValidation;

@AutoService(value={Salesforce.class})
public class Salesforce
extends Service<SalesforceAccount, ForceApi, SalesforceValidation> {
    private static final Logger LOG = LoggerFactory.getLogger(Salesforce.class);

    protected ForceApi client() {
        if (this.client == null) {
            WaitUtils.waitFor(() -> {
                try {
                    this.client = new ForceApi(new ApiConfig().setClientId(((SalesforceAccount)this.account()).clientId()).setClientSecret(((SalesforceAccount)this.account()).clientSecret()).setUsername(((SalesforceAccount)this.account()).userName()).setPassword(((SalesforceAccount)this.account()).password()).setForceURL(((SalesforceAccount)this.account()).loginUrl()));
                    return true;
                }
                catch (Exception ex) {
                    LOG.error("Unable to connect to salesforce, will retry in 5 minutes", (Throwable)ex);
                    return false;
                }
            }, (int)3, (long)300000L, (String)"Trying to connect to SalesForce");
        }
        return (ForceApi)this.client;
    }

    public SalesforceValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new Salesforce validation");
            this.validation = new SalesforceValidation(this.client());
        }
        return (SalesforceValidation)this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
    }
}

