/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.salesforce.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.force.api.ApiException;
import com.force.api.ForceApi;
import com.force.api.QueryResult;
import com.force.api.ResourceRepresentation;
import com.force.api.http.Http;
import com.force.api.http.HttpRequest;
import com.force.api.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.validation.Validation;
import software.tnb.salesforce.dto.Account;
import software.tnb.salesforce.dto.Case;
import software.tnb.salesforce.dto.Lead;

public class SalesforceValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceValidation.class);
    private final ForceApi client;

    public SalesforceValidation(ForceApi client) {
        this.client = client;
    }

    public String createNewLead(Lead lead) {
        String leadId = this.client.createSObject("lead", (Object)lead);
        LOG.debug("Created lead with id " + leadId);
        return leadId;
    }

    public String createNewLead(String firstName, String lastName, String email, String companyName) {
        return this.createNewLead(new Lead(firstName, lastName, email, companyName));
    }

    public void updateLead(String email, Lead newLead) {
        Optional<Lead> sfLead = this.getLeadByEmail(email);
        Assertions.assertTrue((boolean)sfLead.isPresent());
        String leadId = sfLead.get().getId();
        this.client.updateSObject("lead", leadId, (Object)newLead);
    }

    public void deleteLead(String email) {
        Optional<Lead> lead = this.getLeadByEmail(email);
        if (lead.isPresent()) {
            String leadId = lead.get().getId();
            this.client.deleteSObject("lead", leadId);
            LOG.debug("Deleting salesforce lead: {}", (Object)lead.get());
        }
    }

    public String createCase(String accountId, String status, String origin, String subject) {
        Case newCase = new Case(accountId, status, origin, subject);
        String caseId = this.client.createSObject("Case", (Object)newCase);
        LOG.debug("Created case with id " + caseId);
        return caseId;
    }

    public void deleteCase(String id) {
        this.client.deleteSObject("case", id);
        LOG.debug("Deleting salesforce case with id : {}", (Object)id);
    }

    public String createAccount(String name, String phone) {
        Account sfAccount = new Account(name, phone);
        String accountId = this.client.createSObject("Account", (Object)sfAccount);
        LOG.debug("Created account with id " + accountId);
        return accountId;
    }

    public void deleteAccount(String id) {
        this.client.deleteSObject("account", id);
        LOG.debug("Deleting salesforce account with id : {}", (Object)id);
    }

    public List<Map> getTopics() {
        QueryResult queryResult = this.client.query("SELECT Id,Name FROM PushTopic");
        return queryResult.getRecords();
    }

    public void deleteTopic(String topicName) {
        LOG.info("deleting topic {}", (Object)topicName);
        QueryResult queryResult = this.client.query("SELECT Id FROM PushTopic where Name = '" + topicName + "'");
        if (queryResult.getTotalSize() > 0) {
            String topicId = (String)((Map)queryResult.getRecords().get(0)).get("Id");
            this.client.deleteSObject("PushTopic", topicId);
        }
    }

    public Optional<Lead> getLeadByEmail(String emailAddress) {
        QueryResult queryResult = this.client.query("SELECT Id,FirstName,LastName,Email,Company FROM lead where Email = '" + emailAddress + "'", Lead.class);
        return queryResult.getTotalSize() > 0 ? Optional.of((Lead)queryResult.getRecords().get(0)) : Optional.empty();
    }

    public List<Case> getCasesByAccountId(String accountId) {
        QueryResult queryResult = this.client.query("SELECT Id,Status,Origin,AccountId,Subject FROM case where AccountId = '" + accountId + "'", Case.class);
        return queryResult.getRecords();
    }

    public ResourceRepresentation getBulkJob(String id, Boolean isBulkV2) throws ApiException {
        if (isBulkV2.booleanValue()) {
            return this.client.get("/jobs/ingest/" + id);
        }
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        HttpResponse res = Http.send((HttpRequest)new HttpRequest().url(this.client.getSession().getApiEndpoint() + "/services/async/54.0/job/" + id).method("GET").header("X-SFDC-Session", this.client.getSession().getAccessToken()).header("Accept", "application/json").header("Content-Type", "application/json"));
        return new ResourceRepresentation(res, jsonMapper);
    }
}

