/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.microstream.versionagnostic;

import java.util.List;
import java.util.Objects;
import software.xdev.micromigration.microstream.versionagnostic.VersionAgnosticMigrationManager;
import software.xdev.micromigration.microstream.versionagnostic.VersionAgnosticTunnelingEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;
import software.xdev.micromigration.notification.ScriptExecutionNotificationWithoutScriptReference;
import software.xdev.micromigration.version.MigrationVersion;
import software.xdev.micromigration.version.VersionedRootWithHistory;

public abstract class VersionAgnosticMigrationEmbeddedStorageManager<T, E>
implements AutoCloseable {
    private final MicroMigrater migrater;
    private VersionedRootWithHistory versionRoot;
    private VersionAgnosticTunnelingEmbeddedStorageManager<E> tunnelingManager;

    public VersionAgnosticMigrationEmbeddedStorageManager(VersionAgnosticTunnelingEmbeddedStorageManager<E> tunnelingManager, MicroMigrater migrater) {
        this.tunnelingManager = Objects.requireNonNull(tunnelingManager);
        this.migrater = Objects.requireNonNull(migrater);
    }

    protected VersionAgnosticTunnelingEmbeddedStorageManager<E> getTunnelingManager() {
        return this.tunnelingManager;
    }

    public T start() {
        this.tunnelingManager.start();
        if (this.tunnelingManager.root() instanceof VersionedRootWithHistory) {
            this.versionRoot = (VersionedRootWithHistory)this.tunnelingManager.root();
        } else {
            this.versionRoot = new VersionedRootWithHistory(this.tunnelingManager.root());
            this.tunnelingManager.setRoot(this.versionRoot);
            this.tunnelingManager.storeRoot();
        }
        new VersionAgnosticMigrationManager(this.versionRoot, this.migrater, this).migrate(this.versionRoot.getRoot());
        return (T)this;
    }

    public MigrationVersion getCurrentVersion() {
        return this.versionRoot.getVersion();
    }

    public Object root() {
        return this.versionRoot.getRoot();
    }

    public List<ScriptExecutionNotificationWithoutScriptReference> getMigrationHistory() {
        return this.versionRoot.getMigrationHistory();
    }

    public Object setRoot(Object newRoot) {
        this.versionRoot.setRoot(newRoot);
        return newRoot;
    }

    public long storeRoot() {
        this.tunnelingManager.store(this.versionRoot);
        return this.tunnelingManager.store(this.versionRoot.getRoot());
    }

    public long store(Object objectToStore) {
        return this.tunnelingManager.store(objectToStore);
    }

    public boolean shutdown() {
        return this.tunnelingManager.shutdown();
    }

    @Override
    public void close() {
        this.tunnelingManager.close();
    }
}

