/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.microstream.versionagnostic;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.xdev.micromigration.microstream.versionagnostic.VersionAgnosticMigrationEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;
import software.xdev.micromigration.notification.ScriptExecutionNotificationWithScriptReference;
import software.xdev.micromigration.notification.ScriptExecutionNotificationWithoutScriptReference;
import software.xdev.micromigration.version.MigrationVersion;
import software.xdev.micromigration.version.Versioned;
import software.xdev.micromigration.version.VersionedAndKeeperOfHistory;

public class VersionAgnosticMigrationManager<T> {
    private final Supplier<MigrationVersion> currentVersionGetter;
    private final Consumer<MigrationVersion> currentVersionSetter;
    private final Consumer<MigrationVersion> currentVersionStorer;
    private final MicroMigrater migrater;
    private final VersionAgnosticMigrationEmbeddedStorageManager<?, T> storageManager;

    public VersionAgnosticMigrationManager(Supplier<MigrationVersion> currentVersionGetter, Consumer<MigrationVersion> currentVersionSetter, Consumer<MigrationVersion> currentVersionStorer, MicroMigrater migrater, VersionAgnosticMigrationEmbeddedStorageManager<?, T> storageManager) {
        Objects.requireNonNull(currentVersionGetter);
        Objects.requireNonNull(currentVersionSetter);
        Objects.requireNonNull(currentVersionStorer);
        Objects.requireNonNull(migrater);
        Objects.requireNonNull(storageManager);
        this.currentVersionGetter = currentVersionGetter;
        this.currentVersionSetter = currentVersionSetter;
        this.currentVersionStorer = currentVersionStorer;
        this.migrater = migrater;
        this.storageManager = storageManager;
    }

    public VersionAgnosticMigrationManager(Versioned versionedObject, MicroMigrater migrater, VersionAgnosticMigrationEmbeddedStorageManager<?, T> storageManager) {
        this(() -> versionedObject.getVersion(), version -> versionedObject.setVersion((MigrationVersion)version), version -> storageManager.store(versionedObject), migrater, storageManager);
        Objects.requireNonNull(versionedObject);
    }

    public VersionAgnosticMigrationManager(VersionedAndKeeperOfHistory versionedObject, MicroMigrater migrater, VersionAgnosticMigrationEmbeddedStorageManager<?, T> storageManager) {
        this(() -> versionedObject.getVersion(), version -> versionedObject.setVersion((MigrationVersion)version), version -> storageManager.store(versionedObject), migrater, storageManager);
        Objects.requireNonNull(versionedObject);
        migrater.registerNotificationConsumer(executedScript -> versionedObject.addExecutedScript(new ScriptExecutionNotificationWithoutScriptReference((ScriptExecutionNotificationWithScriptReference)executedScript)));
    }

    public void migrate(Object objectToMigrate) {
        MigrationVersion versionBeforeUpdate = this.currentVersionGetter.get();
        MigrationVersion versionAfterUpdate = this.migrater.migrateToNewest(versionBeforeUpdate, this.storageManager, objectToMigrate);
        if (!versionAfterUpdate.equals(versionBeforeUpdate)) {
            this.currentVersionSetter.accept(versionAfterUpdate);
            this.currentVersionStorer.accept(versionAfterUpdate);
        }
    }
}

