/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.migrater;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import software.xdev.micromigration.microstream.versionagnostic.VersionAgnosticMigrationEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;
import software.xdev.micromigration.migrater.VersionAlreadyRegisteredException;
import software.xdev.micromigration.notification.ScriptExecutionNotificationWithScriptReference;
import software.xdev.micromigration.scripts.Context;
import software.xdev.micromigration.scripts.VersionAgnosticMigrationScript;
import software.xdev.micromigration.version.MigrationVersion;

public abstract class AbstractMigrater
implements MicroMigrater {
    private List<Consumer<ScriptExecutionNotificationWithScriptReference>> notificationConsumers = new ArrayList<Consumer<ScriptExecutionNotificationWithScriptReference>>();

    @Override
    public void registerNotificationConsumer(Consumer<ScriptExecutionNotificationWithScriptReference> notificationConsumer) {
        this.notificationConsumers.add(notificationConsumer);
    }

    @Override
    public <E extends VersionAgnosticMigrationEmbeddedStorageManager<?, ?>> MigrationVersion migrateToNewest(MigrationVersion fromVersion, E storageManager, Object root) {
        Objects.requireNonNull(fromVersion);
        Objects.requireNonNull(storageManager);
        TreeSet<VersionAgnosticMigrationScript<?, ?>> sortedScripts = this.getSortedScripts();
        if (sortedScripts.size() > 0) {
            return this.migrateToVersion(fromVersion, this.getSortedScripts().last().getTargetVersion(), storageManager, root);
        }
        return fromVersion;
    }

    @Override
    public <E extends VersionAgnosticMigrationEmbeddedStorageManager<?, ?>> MigrationVersion migrateToVersion(MigrationVersion fromVersion, MigrationVersion targetVersion, E storageManager, Object objectToMigrate) {
        Objects.requireNonNull(fromVersion);
        Objects.requireNonNull(targetVersion);
        Objects.requireNonNull(storageManager);
        MigrationVersion updateVersionWhichWasExecuted = fromVersion;
        Iterator<VersionAgnosticMigrationScript<?, ?>> iterator = this.getSortedScripts().iterator();
        while (iterator.hasNext()) {
            VersionAgnosticMigrationScript<?, ?> script;
            VersionAgnosticMigrationScript<?, ?> castedScript = script = iterator.next();
            if (MigrationVersion.COMPARATOR.compare(fromVersion, script.getTargetVersion()) >= 0 || MigrationVersion.COMPARATOR.compare(script.getTargetVersion(), targetVersion) > 0) continue;
            LocalDateTime startDate = null;
            MigrationVersion versionBeforeUpdate = updateVersionWhichWasExecuted;
            if (!this.notificationConsumers.isEmpty()) {
                startDate = LocalDateTime.now();
            }
            updateVersionWhichWasExecuted = this.migrateWithScript(castedScript, storageManager, objectToMigrate);
            if (this.notificationConsumers.isEmpty()) continue;
            ScriptExecutionNotificationWithScriptReference scriptNotification = new ScriptExecutionNotificationWithScriptReference(script, versionBeforeUpdate, updateVersionWhichWasExecuted, startDate, LocalDateTime.now());
            this.notificationConsumers.forEach(consumer -> consumer.accept(scriptNotification));
        }
        return updateVersionWhichWasExecuted;
    }

    private <T, E extends VersionAgnosticMigrationEmbeddedStorageManager<?, ?>> MigrationVersion migrateWithScript(VersionAgnosticMigrationScript<T, E> script, E storageManager, Object objectToMigrate) {
        Object castedObjectToMigrate = objectToMigrate;
        script.migrate(new Context<Object, E>(castedObjectToMigrate, storageManager));
        return script.getTargetVersion();
    }

    protected void checkIfVersionIsAlreadyRegistered(VersionAgnosticMigrationScript<?, ?> scriptToCheck) {
        for (VersionAgnosticMigrationScript<?, ?> alreadyRegisteredScript : this.getSortedScripts()) {
            if (MigrationVersion.COMPARATOR.compare(alreadyRegisteredScript.getTargetVersion(), scriptToCheck.getTargetVersion()) != 0) continue;
            throw new VersionAlreadyRegisteredException(alreadyRegisteredScript.getTargetVersion(), alreadyRegisteredScript, scriptToCheck);
        }
    }
}

