/*
 * Decompiled with CFR 0.152.
 */
package solutions.viae.databasemanagement.mongodb.factories;

import com.mongodb.Block;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import solutions.viae.coreutils.domain.Environment;
import solutions.viae.coreutils.service.Logger;
import solutions.viae.databasemanagement.core.api.factories.DatabaseManagementRepositoryFactory;
import solutions.viae.databasemanagement.core.api.repositories.ReadOnlyDatabasesRepository;
import solutions.viae.databasemanagement.core.impl.factories.DatabaseManagementCrudRepositoryFactory;
import solutions.viae.databasemanagement.core.impl.repositories.CrudDatabasesRepository;
import solutions.viae.databasemanagement.mongodb.factories.DbManagementRepositoryFactory;
import solutions.viae.databasemanagement.mongodb.repositories.DefaultDatabasesRepository;
import solutions.viae.databasemanagement.mongodb.repositories.InMemoryDatabasesRepository;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lsolutions/viae/databasemanagement/mongodb/factories/DbManagementRepositoryFactory;", "Lsolutions/viae/databasemanagement/core/api/factories/DatabaseManagementRepositoryFactory;", "Lsolutions/viae/databasemanagement/core/impl/factories/DatabaseManagementCrudRepositoryFactory;", "environment", "Lsolutions/viae/coreutils/domain/Environment;", "mongoServerAddresses", "", "", "mongoUserName", "mongoPassword", "mongoSource", "logger", "Lsolutions/viae/coreutils/service/Logger;", "(Lsolutions/viae/coreutils/domain/Environment;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lsolutions/viae/coreutils/service/Logger;)V", "crudDatabasesRepository", "Lsolutions/viae/databasemanagement/core/impl/repositories/CrudDatabasesRepository;", "getCrudDatabasesRepository", "()Lsolutions/viae/databasemanagement/core/impl/repositories/CrudDatabasesRepository;", "databasesRepository", "readOnlyDatabasesRepository", "Lsolutions/viae/databasemanagement/core/api/repositories/ReadOnlyDatabasesRepository;", "getReadOnlyDatabasesRepository", "()Lsolutions/viae/databasemanagement/core/api/repositories/ReadOnlyDatabasesRepository;", "viae-database-management-mongodb"})
public final class DbManagementRepositoryFactory
implements DatabaseManagementRepositoryFactory,
DatabaseManagementCrudRepositoryFactory {
    private final CrudDatabasesRepository databasesRepository;
    private final Environment environment;
    private final List<String> mongoServerAddresses;
    private final String mongoUserName;
    private final String mongoPassword;
    private final String mongoSource;
    private final Logger logger;

    @NotNull
    public ReadOnlyDatabasesRepository getReadOnlyDatabasesRepository() {
        return (ReadOnlyDatabasesRepository)this.databasesRepository;
    }

    @NotNull
    public CrudDatabasesRepository getCrudDatabasesRepository() {
        return this.databasesRepository;
    }

    public DbManagementRepositoryFactory(@NotNull Environment environment, @NotNull List<String> mongoServerAddresses, @NotNull String mongoUserName, @NotNull String mongoPassword, @NotNull String mongoSource, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(mongoServerAddresses, (String)"mongoServerAddresses");
        Intrinsics.checkParameterIsNotNull((Object)mongoUserName, (String)"mongoUserName");
        Intrinsics.checkParameterIsNotNull((Object)mongoPassword, (String)"mongoPassword");
        Intrinsics.checkParameterIsNotNull((Object)mongoSource, (String)"mongoSource");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.environment = environment;
        this.mongoServerAddresses = mongoServerAddresses;
        this.mongoUserName = mongoUserName;
        this.mongoPassword = mongoPassword;
        this.mongoSource = mongoSource;
        this.logger = logger;
        if (Environment.IN_MEMORY == this.environment) {
            this.databasesRepository = new InMemoryDatabasesRepository();
        } else {
            MongoClient mongoSyncClient = null;
            if (Environment.LOCAL == this.environment) {
                String string = System.getenv("MONGODB_HOST");
                if (string == null) {
                    string = "mongodb://localhost:27017";
                }
                MongoClient mongoClient = MongoClients.create((String)string);
                Intrinsics.checkExpressionValueIsNotNull((Object)mongoClient, (String)"MongoClients.create(Syst\u2026ngodb://localhost:27017\")");
                mongoSyncClient = mongoClient;
            } else {
                String string = this.mongoPassword;
                String string2 = this.mongoSource;
                String string3 = this.mongoUserName;
                MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings((Block)new Block<ClusterSettings.Builder>(this){
                    final /* synthetic */ DbManagementRepositoryFactory this$0;

                    public final void apply(@NotNull ClusterSettings.Builder builder) {
                        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                        builder.hosts(DbManagementRepositoryFactory.access$getMongoServerAddresses$p(this.this$0).stream().map(settings.1.INSTANCE).collect(Collectors.toList()));
                    }
                    {
                        this.this$0 = dbManagementRepositoryFactory;
                    }
                }).applyToSslSettings((Block)settings.2.INSTANCE);
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                char[] cArray = string4.toCharArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                char[] cArray2 = cArray;
                MongoClientSettings mongoClientSettings = builder.credential(MongoCredential.createScramSha1Credential((String)string3, (String)string2, (char[])cArray2)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)mongoClientSettings, (String)"MongoClientSettings.buil\u2026                 .build()");
                MongoClientSettings settings2 = mongoClientSettings;
                MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings2);
                Intrinsics.checkExpressionValueIsNotNull((Object)mongoClient, (String)"MongoClients.create(settings)");
                mongoSyncClient = mongoClient;
            }
            this.databasesRepository = new DefaultDatabasesRepository(mongoSyncClient);
        }
    }

    public static final /* synthetic */ List access$getMongoServerAddresses$p(DbManagementRepositoryFactory $this) {
        return $this.mongoServerAddresses;
    }
}

