/*
 * Decompiled with CFR 0.152.
 */
package solutions.viae.databasemanagement.mongodb.repositories;

import com.mongodb.Function;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Updates;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solutions.viae.coreutils.domain.DatabaseId;
import solutions.viae.coreutils.domain.Environment;
import solutions.viae.coreutils.domain.Response;
import solutions.viae.coreutils.utils.DateUtils;
import solutions.viae.databasemanagement.core.api.domain.Database;
import solutions.viae.databasemanagement.core.impl.api.CreateDatabaseData;
import solutions.viae.databasemanagement.core.impl.repositories.CrudDatabasesRepository;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J?\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001a\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001bJ?\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001a\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001a\"\u00020\u0012\u00a2\u0006\u0002\u0010\u001fJ?\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001a\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J4\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\"0\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00102\u000e\u0010&\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020*H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lsolutions/viae/databasemanagement/mongodb/repositories/DefaultDatabasesRepository;", "Lsolutions/viae/databasemanagement/core/impl/repositories/CrudDatabasesRepository;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "(Lcom/mongodb/client/MongoClient;)V", "databaseCache", "", "Lsolutions/viae/coreutils/domain/DatabaseId;", "Lsolutions/viae/databasemanagement/core/api/domain/Database;", "cleanUpAllNoneActiveDatabases", "Lsolutions/viae/coreutils/domain/Response;", "", "createDatabase", "database", "Lsolutions/viae/databasemanagement/core/impl/api/CreateDatabaseData;", "createIndex", "", "dbName", "", "collectionName", "indexName", "index", "Lorg/bson/conversions/Bson;", "databaseId", "ensureAscendingIndex", "fieldNames", "", "(Lsolutions/viae/coreutils/domain/DatabaseId;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lsolutions/viae/coreutils/domain/Response;", "ensureDescendingIndex", "ensureGeoLocationIndex", "databaseName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lsolutions/viae/coreutils/domain/Response;", "get", "getAvailableDatabases", "", "environment", "Lsolutions/viae/coreutils/domain/Environment;", "active", "applicationName", "Lsolutions/viae/coreutils/domain/ApplicationName;", "getInfoCollection", "Lcom/mongodb/client/MongoCollection;", "Lorg/bson/Document;", "markDatabaseActive", "markDatabaseInactive", "refreshCachedDatabase", "removeDatabase", "toDatabase", "document", "viae-database-management-mongodb"})
public final class DefaultDatabasesRepository
implements CrudDatabasesRepository {
    private final Map<DatabaseId, Database> databaseCache;
    private final MongoClient mongoClient;

    @NotNull
    public Response<Boolean> ensureGeoLocationIndex(@NotNull DatabaseId databaseId, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        try {
            Bson bson = Indexes.geo2dsphere((List)ArraysKt.asList((Object[])fieldNames));
            Intrinsics.checkExpressionValueIsNotNull((Object)bson, (String)"Indexes.geo2dsphere(fieldNames.asList())");
            Bson index = bson;
            response2 = this.createIndex(databaseId, collectionName, indexName, index);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in ensureGeoLocationIndex: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public final Response<Boolean> ensureGeoLocationIndex(@NotNull String databaseName, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseName, (String)"databaseName");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        try {
            Bson bson = Indexes.geo2dsphere((List)ArraysKt.asList((Object[])fieldNames));
            Intrinsics.checkExpressionValueIsNotNull((Object)bson, (String)"Indexes.geo2dsphere(fieldNames.asList())");
            Bson index = bson;
            response2 = this.createIndex(databaseName, collectionName, indexName, index);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in ensureGeoLocationIndex: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Boolean> ensureAscendingIndex(@NotNull DatabaseId databaseId, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        try {
            Bson bson = Indexes.ascending((List)ArraysKt.asList((Object[])fieldNames));
            Intrinsics.checkExpressionValueIsNotNull((Object)bson, (String)"Indexes.ascending(fieldNames.asList())");
            Bson index = bson;
            response2 = this.createIndex(databaseId, collectionName, indexName, index);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in ensureAscendingIndex: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Boolean> ensureDescendingIndex(@NotNull DatabaseId databaseId, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        try {
            Bson bson = Indexes.descending((List)ArraysKt.asList((Object[])fieldNames));
            Intrinsics.checkExpressionValueIsNotNull((Object)bson, (String)"Indexes.descending(fieldNames.asList())");
            Bson index = bson;
            response2 = this.createIndex(databaseId, collectionName, indexName, index);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in ensureDescendingIndex: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Unit> cleanUpAllNoneActiveDatabases() {
        Response response2;
        try {
            MongoIterable mongoIterable = this.getInfoCollection().find().map(new Function<TResult, U>(this){
                final /* synthetic */ DefaultDatabasesRepository this$0;

                @NotNull
                public final Database apply(@NotNull Document d) {
                    Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                    return DefaultDatabasesRepository.access$toDatabase(this.this$0, d);
                }
                {
                    this.this$0 = defaultDatabasesRepository;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"getInfoCollection()\n    \u2026ap { d -> toDatabase(d) }");
            Iterable $this$forEach$iv = (Iterable)mongoIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Database e = (Database)element$iv;
                boolean bl = false;
                if (e.isActive().values().contains(true) || StringsKt.startsWith$default((String)e.getName(), (String)"do-not-remove-on-", (boolean)false, (int)2, null)) continue;
                this.removeDatabase(e.getId());
                this.databaseCache.remove(e.getId());
            }
            Unit result2 = Unit.INSTANCE;
            response2 = Response.Companion.success((Object)result2);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in cleanUpAllNoneActiveDatabases: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Unit> markDatabaseActive(@NotNull DatabaseId databaseId, @NotNull Environment environment) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        try {
            this.getInfoCollection().findOneAndUpdate(Filters.eq((String)"id", (Object)databaseId.asString()), Updates.set((String)("activeEnvironments." + environment.name()), (Object)true));
            this.refreshCachedDatabase(databaseId);
            response2 = Response.Companion.success();
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in markDatabaseActive: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Unit> markDatabaseInactive(@NotNull DatabaseId databaseId, @NotNull Environment environment) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        try {
            this.getInfoCollection().findOneAndUpdate(Filters.eq((String)"id", (Object)databaseId.asString()), Updates.set((String)("activeEnvironments." + environment.name()), (Object)false));
            this.refreshCachedDatabase(databaseId);
            response2 = Response.Companion.success();
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in markDatabaseInactive: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Database> get(@NotNull DatabaseId databaseId) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        try {
            Database database;
            block8: {
                Document document;
                block10: {
                    block9: {
                        block7: {
                            if (!this.databaseCache.containsKey(databaseId)) break block7;
                            database = this.databaseCache.get(databaseId);
                            if (database == null) {
                                Intrinsics.throwNpe();
                            }
                            break block8;
                        }
                        FindIterable findIterable = this.getInfoCollection().find(Filters.eq((String)"id", (Object)databaseId.asString()));
                        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"getInfoCollection().find\u2026, databaseId.asString()))");
                        FindIterable result2 = findIterable;
                        document = (Document)result2.first();
                        if (document == null) break block9;
                        Document document2 = document;
                        boolean bl = false;
                        boolean bl2 = false;
                        Document it = document2;
                        boolean bl3 = false;
                        Document document3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"it");
                        Database db = this.toDatabase(document3);
                        this.databaseCache.put(databaseId, db);
                        Response response3 = Response.Companion.success((Object)db);
                        document = response3;
                        if (response3 != null) break block10;
                    }
                    document = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "database '" + databaseId.asString() + "' not found");
                }
                return document;
            }
            response2 = Response.Companion.success((Object)database);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in get: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<Unit> removeDatabase(@NotNull DatabaseId databaseId) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        try {
            Response response3 = this.get(databaseId).map((Function1)new Function1<Database, Document>(this, databaseId){
                final /* synthetic */ DefaultDatabasesRepository this$0;
                final /* synthetic */ DatabaseId $databaseId;

                @Nullable
                public final Document invoke(@Nullable Database db) {
                    MongoClient mongoClient = DefaultDatabasesRepository.access$getMongoClient$p(this.this$0);
                    Database database = db;
                    if (database == null) {
                        Intrinsics.throwNpe();
                    }
                    mongoClient.getDatabase(database.getName()).drop();
                    return (Document)DefaultDatabasesRepository.access$getInfoCollection(this.this$0).findOneAndDelete(Filters.eq((String)"id", (Object)this.$databaseId.asString()));
                }
                {
                    this.this$0 = defaultDatabasesRepository;
                    this.$databaseId = databaseId;
                    super(1);
                }
            });
            this.refreshCachedDatabase(databaseId);
            response2 = response3.hasNoErrors() ? Response.Companion.success() : Response.Companion.failure(response3.getErrors());
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in removeDatabase: " + e.getLocalizedMessage());
        }
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response<Unit> createDatabase(@NotNull CreateDatabaseData database) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        try {
            Map map;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            String databaseName = database.getName();
            Map map2 = database.isActive();
            String string = "activeEnvironments";
            Document document = new Document().append("id", (Object)database.getId().asString()).append("created", (Object)DateUtils.Companion.toString(database.getCreatedTs())).append("name", (Object)databaseName).append("application", (Object)database.getApplication());
            MongoCollection<Document> mongoCollection = this.getInfoCollection();
            boolean $i$f$mapKeys = false;
            void var5_9 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void e;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                String string2 = ((Environment)e.getKey()).name();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string3 = string2;
                Map map3 = map;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(string3, entry);
            }
            Map map4 = map = destination$iv$iv;
            mongoCollection.insertOne((Object)document.append(string, (Object)new Document(map4)));
            response2 = Response.Companion.success();
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in createDatabase: " + e.getLocalizedMessage());
        }
        return response2;
    }

    @NotNull
    public Response<List<Database>> getAvailableDatabases(@NotNull Environment environment, boolean active, @Nullable String applicationName) {
        Response response2;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        try {
            MongoIterable mongoIterable = this.getInfoCollection().find(Filters.and((Iterable)CollectionsKt.listOfNotNull((Object[])new Bson[]{Filters.eq((String)("activeEnvironments." + environment.name()), (Object)active), applicationName != null ? Filters.eq((String)"application", (Object)applicationName) : null}))).map(new Function<TResult, U>(this){
                final /* synthetic */ DefaultDatabasesRepository this$0;

                @NotNull
                public final Database apply(@NotNull Document d) {
                    Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                    return DefaultDatabasesRepository.access$toDatabase(this.this$0, d);
                }
                {
                    this.this$0 = defaultDatabasesRepository;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"getInfoCollection()\n    \u2026ap { d -> toDatabase(d) }");
            List result2 = CollectionsKt.toList((Iterable)((Iterable)mongoIterable));
            response2 = Response.Companion.success((Object)result2);
        }
        catch (Exception e) {
            response2 = Response.Companion.failure(Reflection.getOrCreateKotlinClass(DefaultDatabasesRepository.class), "error in getAvailableDatabases: " + e.getLocalizedMessage());
        }
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    private final Database toDatabase(Document document) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Object object2;
        Environment environment;
        Object e;
        Map map;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        String string = document.getString((Object)"id");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.getString(\"id\")");
        DatabaseId databaseId = DatabaseId.Companion.fromString(string);
        String string2 = document.getString((Object)"name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"document.getString(\"name\")");
        String string3 = document.getString((Object)"application");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"document.getString(\"application\")");
        String string4 = document.getString((Object)"created");
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"document.getString(\"created\")");
        ZonedDateTime zonedDateTime = DateUtils.Companion.toTimeStamp(string4);
        Object object3 = document.get((Object)"activeEnvironments", Document.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"document.get(\"activeEnvi\u2026s\", Document::class.java)");
        Map map2 = MapsKt.toMap((Map)((Map)object3));
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string5 = string3;
        String string6 = string2;
        DatabaseId databaseId2 = databaseId;
        boolean $i$f$mapKeys = false;
        void var4_8 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Object k = e.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"e.key");
            environment = Environment.valueOf((String)((String)k));
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = environment;
            object = map;
            boolean bl2 = false;
            e = it$iv$iv.getValue();
            object.put(object2, e);
        }
        $this$mapKeys$iv = map = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void e2;
            void it$iv$iv;
            e = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            object2 = it$iv$iv.getKey();
            object = (Map.Entry)element$iv$iv$iv;
            environment = object2;
            map = map3;
            boolean bl3 = false;
            Object v = e2.getValue();
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            Boolean bl4 = (boolean)((Boolean)v);
            map.put(environment, bl4);
        }
        Map map4 = map = destination$iv$iv;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        String string7 = string5;
        String string8 = string6;
        DatabaseId databaseId3 = databaseId2;
        return new Database(databaseId3, string8, string7, zonedDateTime3, map4);
    }

    private final void refreshCachedDatabase(DatabaseId databaseId) {
        this.databaseCache.remove(databaseId);
        this.get(databaseId);
    }

    private final MongoCollection<Document> getInfoCollection() {
        MongoCollection mongoCollection = this.mongoClient.getDatabase("ps_databases_meta_data").getCollection("info");
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"mongoClient\n            \u2026   .getCollection(\"info\")");
        return mongoCollection;
    }

    private final Response<Boolean> createIndex(DatabaseId databaseId, String collectionName, String indexName, Bson index) {
        String dbName = ((Database)this.get(databaseId).getData()).getName();
        return this.createIndex(dbName, collectionName, indexName, index);
    }

    /*
     * WARNING - void declaration
     */
    private final Response<Boolean> createIndex(String dbName, String collectionName, String indexName, Bson index) {
        Response response2;
        void $this$mapTo$iv$iv;
        MongoCollection mongoCollection = this.mongoClient.getDatabase(dbName).getCollection(collectionName);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"mongoClient.getDatabase(\u2026ollection(collectionName)");
        MongoCollection collection = mongoCollection;
        ListIndexesIterable listIndexesIterable = collection.listIndexes();
        Intrinsics.checkExpressionValueIsNotNull((Object)listIndexesIterable, (String)"collection\n            .listIndexes()");
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)listIndexesIterable));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void d;
            Document document = (Document)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = d.getString((Object)"name");
            collection2.add(string);
        }
        List indexNames = (List)destination$iv$iv;
        if (!indexNames.contains(indexName)) {
            collection.createIndex(index, new IndexOptions().name(indexName));
            response2 = Response.Companion.success((Object)true);
        } else {
            response2 = Response.Companion.success((Object)false);
        }
        return response2;
    }

    public DefaultDatabasesRepository(@NotNull MongoClient mongoClient) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)mongoClient, (String)"mongoClient");
        this.mongoClient = mongoClient;
        DefaultDatabasesRepository defaultDatabasesRepository = this;
        boolean bl = false;
        defaultDatabasesRepository.databaseCache = map = (Map)new LinkedHashMap();
    }

    @NotNull
    public Response<DatabaseId> getActiveDatabaseId(@NotNull Environment environment, @NotNull String applicationName) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
        return CrudDatabasesRepository.DefaultImpls.getActiveDatabaseId((CrudDatabasesRepository)this, (Environment)environment, (String)applicationName);
    }

    public static final /* synthetic */ Database access$toDatabase(DefaultDatabasesRepository $this, Document document) {
        return $this.toDatabase(document);
    }

    public static final /* synthetic */ MongoClient access$getMongoClient$p(DefaultDatabasesRepository $this) {
        return $this.mongoClient;
    }

    public static final /* synthetic */ MongoCollection access$getInfoCollection(DefaultDatabasesRepository $this) {
        return $this.getInfoCollection();
    }
}

