/*
 * Decompiled with CFR 0.152.
 */
package solutions.viae.databasemanagement.mongodb.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solutions.viae.coreutils.domain.DatabaseId;
import solutions.viae.coreutils.domain.Environment;
import solutions.viae.coreutils.domain.Response;
import solutions.viae.databasemanagement.core.api.domain.Database;
import solutions.viae.databasemanagement.core.impl.api.CreateDatabaseData;
import solutions.viae.databasemanagement.core.impl.repositories.CrudDatabasesRepository;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J?\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0016\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0016\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0016\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J4\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0 0\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00102\u000e\u0010!\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\"H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lsolutions/viae/databasemanagement/mongodb/repositories/InMemoryDatabasesRepository;", "Lsolutions/viae/databasemanagement/core/impl/repositories/CrudDatabasesRepository;", "()V", "databaseIds", "", "Lsolutions/viae/coreutils/domain/DatabaseId;", "databases", "", "Lsolutions/viae/databasemanagement/core/api/domain/Database;", "cleanUpAllNoneActiveDatabases", "Lsolutions/viae/coreutils/domain/Response;", "", "createDatabase", "database", "Lsolutions/viae/databasemanagement/core/impl/api/CreateDatabaseData;", "ensureAscendingIndex", "", "databaseId", "collectionName", "", "indexName", "fieldNames", "", "(Lsolutions/viae/coreutils/domain/DatabaseId;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lsolutions/viae/coreutils/domain/Response;", "ensureDescendingIndex", "ensureGeoLocationIndex", "filterOnActive", "active", "environment", "Lsolutions/viae/coreutils/domain/Environment;", "get", "getAvailableDatabases", "", "applicationName", "Lsolutions/viae/coreutils/domain/ApplicationName;", "markDatabaseActive", "markDatabaseInactive", "removeDatabase", "viae-database-management-mongodb"})
public final class InMemoryDatabasesRepository
implements CrudDatabasesRepository {
    private final List<DatabaseId> databaseIds;
    private final Map<DatabaseId, Database> databases;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response<Unit> cleanUpAllNoneActiveDatabases() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.databases.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void e;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DatabaseId databaseId = !((Database)e.getValue()).isActive().values().contains(true) ? (DatabaseId)e.getKey() : null;
            collection.add(databaseId);
        }
        List toBeDeleted = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = toBeDeleted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseId id = (DatabaseId)element$iv;
            boolean bl = false;
            this.databaseIds.remove(id);
            this.databases.remove(id);
        }
        return Response.Companion.success();
    }

    @NotNull
    public Response<Boolean> ensureGeoLocationIndex(@NotNull DatabaseId databaseId, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        return Response.Companion.success((Object)false);
    }

    @NotNull
    public Response<Boolean> ensureAscendingIndex(@NotNull DatabaseId databaseId, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        return Response.Companion.success((Object)false);
    }

    @NotNull
    public Response<Boolean> ensureDescendingIndex(@NotNull DatabaseId databaseId, @NotNull String collectionName, @NotNull String indexName, String ... fieldNames) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)collectionName, (String)"collectionName");
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        return Response.Companion.success((Object)false);
    }

    @NotNull
    public Response<Unit> markDatabaseActive(@NotNull DatabaseId databaseId, @NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Database database = this.databases.get(databaseId);
        if (database == null) {
            Intrinsics.throwNpe();
        }
        Map isActive = MapsKt.toMutableMap((Map)database.isActive());
        isActive.put(environment, true);
        Database database2 = this.databases.get(databaseId);
        if (database2 == null) {
            Intrinsics.throwNpe();
        }
        this.databases.put(databaseId, Database.copy$default((Database)database2, null, null, null, null, (Map)isActive, (int)15, null));
        return Response.Companion.success();
    }

    @NotNull
    public Response<Unit> markDatabaseInactive(@NotNull DatabaseId databaseId, @NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Database database = this.databases.get(databaseId);
        if (database == null) {
            Intrinsics.throwNpe();
        }
        Map isActive = MapsKt.toMutableMap((Map)database.isActive());
        isActive.put(environment, false);
        Database database2 = this.databases.get(databaseId);
        if (database2 == null) {
            Intrinsics.throwNpe();
        }
        this.databases.put(databaseId, Database.copy$default((Database)database2, null, null, null, null, (Map)isActive, (int)15, null));
        return Response.Companion.success();
    }

    @NotNull
    public Response<Database> get(@NotNull DatabaseId databaseId) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Database database = this.databases.get(databaseId);
        if (database == null) {
            Intrinsics.throwNpe();
        }
        return Response.Companion.success((Object)database);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response<List<Database>> getAvailableDatabases(@NotNull Environment environment, boolean active, @Nullable String applicationName) {
        Database d;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Iterable iterable = this.databaseIds;
        Response.Companion companion = Response.Companion;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Database database;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DatabaseId n = (DatabaseId)element$iv$iv;
            boolean bl2 = false;
            if (this.databases.get(n) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Database it$iv$iv = database;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$mapNotNull$iv = list;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            d = (Database)element$iv$iv;
            boolean bl = false;
            if (!this.filterOnActive(d, active, environment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        $this$filter$iv = list;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            d = (Database)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)d.getApplication(), (Object)applicationName) || applicationName == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        return companion.success((Object)list);
    }

    @NotNull
    public Response<Unit> createDatabase(@NotNull CreateDatabaseData database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.databaseIds.add(database.getId());
        this.databases.put(database.getId(), new Database(database.getId(), database.getName(), database.getApplication(), database.getCreatedTs(), database.isActive()));
        return Response.Companion.success();
    }

    @NotNull
    public Response<Unit> removeDatabase(@NotNull DatabaseId databaseId) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        this.databaseIds.remove(databaseId);
        this.databases.remove(databaseId);
        return Response.Companion.success();
    }

    private final boolean filterOnActive(Database database, boolean active, Environment environment) {
        return active ? (Boolean)MapsKt.getValue((Map)database.isActive(), (Object)environment) : (Boolean)MapsKt.getValue((Map)database.isActive(), (Object)environment) == false;
    }

    public InMemoryDatabasesRepository() {
        InMemoryDatabasesRepository inMemoryDatabasesRepository = this;
        boolean bl = false;
        Object object = new ArrayList();
        inMemoryDatabasesRepository.databaseIds = object;
        inMemoryDatabasesRepository = this;
        bl = false;
        inMemoryDatabasesRepository.databases = object = (Map)new LinkedHashMap();
    }

    @NotNull
    public Response<DatabaseId> getActiveDatabaseId(@NotNull Environment environment, @NotNull String applicationName) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
        return CrudDatabasesRepository.DefaultImpls.getActiveDatabaseId((CrudDatabasesRepository)this, (Environment)environment, (String)applicationName);
    }
}

