/*
 * Decompiled with CFR 0.152.
 */
package solutions.viae.requestlog.mongodb.factories;

import com.mongodb.Block;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import solutions.viae.databasemanagement.core.api.domain.Environment;
import solutions.viae.databasemanagement.core.api.repositories.ReadOnlyDatabasesRepository;
import solutions.viae.requestlog.core.factories.CrudRequestLogRepositoryFactory;
import solutions.viae.requestlog.core.repositories.RequestLogsRepository;
import solutions.viae.requestlog.mongodb.factories.MongoDbRequestLogRepositoryFactory;
import solutions.viae.requestlog.mongodb.repositories.InMemoryRequestLogsRepository;
import solutions.viae.requestlog.mongodb.repositories.MongoDbRequestLogsRepository;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lsolutions/viae/requestlog/mongodb/factories/MongoDbRequestLogRepositoryFactory;", "Lsolutions/viae/requestlog/core/factories/CrudRequestLogRepositoryFactory;", "environment", "Lsolutions/viae/databasemanagement/core/api/domain/Environment;", "mongoServerAddresses", "", "", "mongoUserName", "mongoPassword", "mongoSource", "readOnlyDatabasesRepository", "Lsolutions/viae/databasemanagement/core/api/repositories/ReadOnlyDatabasesRepository;", "(Lsolutions/viae/databasemanagement/core/api/domain/Environment;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lsolutions/viae/databasemanagement/core/api/repositories/ReadOnlyDatabasesRepository;)V", "requestLogsRepository", "Lsolutions/viae/requestlog/core/repositories/RequestLogsRepository;", "getRequestLogsRepository", "()Lsolutions/viae/requestlog/core/repositories/RequestLogsRepository;", "viae-request-log-mongodb"})
public final class MongoDbRequestLogRepositoryFactory
implements CrudRequestLogRepositoryFactory {
    @NotNull
    private final RequestLogsRepository requestLogsRepository;
    private final Environment environment;
    private final List<String> mongoServerAddresses;
    private final String mongoUserName;
    private final String mongoPassword;
    private final String mongoSource;
    private final ReadOnlyDatabasesRepository readOnlyDatabasesRepository;

    @NotNull
    public RequestLogsRepository getRequestLogsRepository() {
        return this.requestLogsRepository;
    }

    public MongoDbRequestLogRepositoryFactory(@NotNull Environment environment, @NotNull List<String> mongoServerAddresses, @NotNull String mongoUserName, @NotNull String mongoPassword, @NotNull String mongoSource, @NotNull ReadOnlyDatabasesRepository readOnlyDatabasesRepository) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(mongoServerAddresses, (String)"mongoServerAddresses");
        Intrinsics.checkParameterIsNotNull((Object)mongoUserName, (String)"mongoUserName");
        Intrinsics.checkParameterIsNotNull((Object)mongoPassword, (String)"mongoPassword");
        Intrinsics.checkParameterIsNotNull((Object)mongoSource, (String)"mongoSource");
        Intrinsics.checkParameterIsNotNull((Object)readOnlyDatabasesRepository, (String)"readOnlyDatabasesRepository");
        this.environment = environment;
        this.mongoServerAddresses = mongoServerAddresses;
        this.mongoUserName = mongoUserName;
        this.mongoPassword = mongoPassword;
        this.mongoSource = mongoSource;
        this.readOnlyDatabasesRepository = readOnlyDatabasesRepository;
        if (Environment.IN_MEMORY == this.environment) {
            this.requestLogsRepository = new InMemoryRequestLogsRepository();
        } else {
            MongoClient mongoSyncClient = null;
            if (Environment.LOCAL == this.environment) {
                String string = System.getenv("MONGODB_HOST");
                if (string == null) {
                    string = "mongodb://localhost:27017";
                }
                MongoClient mongoClient = MongoClients.create((String)string);
                Intrinsics.checkExpressionValueIsNotNull((Object)mongoClient, (String)"MongoClients.create(Syst\u2026ngodb://localhost:27017\")");
                mongoSyncClient = mongoClient;
            } else {
                String string = this.mongoPassword;
                String string2 = this.mongoSource;
                String string3 = this.mongoUserName;
                MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings((Block)new Block<ClusterSettings.Builder>(this){
                    final /* synthetic */ MongoDbRequestLogRepositoryFactory this$0;

                    public final void apply(@NotNull ClusterSettings.Builder builder) {
                        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                        builder.hosts(MongoDbRequestLogRepositoryFactory.access$getMongoServerAddresses$p(this.this$0).stream().map(settings.1.INSTANCE).collect(Collectors.toList()));
                    }
                    {
                        this.this$0 = mongoDbRequestLogRepositoryFactory;
                    }
                }).applyToSslSettings((Block)settings.2.INSTANCE);
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                char[] cArray = string4.toCharArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                char[] cArray2 = cArray;
                MongoClientSettings mongoClientSettings = builder.credential(MongoCredential.createScramSha1Credential((String)string3, (String)string2, (char[])cArray2)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)mongoClientSettings, (String)"MongoClientSettings.buil\u2026                 .build()");
                MongoClientSettings settings2 = mongoClientSettings;
                MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings2);
                Intrinsics.checkExpressionValueIsNotNull((Object)mongoClient, (String)"MongoClients.create(settings)");
                mongoSyncClient = mongoClient;
            }
            this.requestLogsRepository = new MongoDbRequestLogsRepository(mongoSyncClient, this.readOnlyDatabasesRepository);
        }
    }

    public static final /* synthetic */ List access$getMongoServerAddresses$p(MongoDbRequestLogRepositoryFactory $this) {
        return $this.mongoServerAddresses;
    }
}

