/*
 * Decompiled with CFR 0.152.
 */
package solutions.viae.requestlog.mongodb.repositories;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solutions.viae.coreutils.domain.ErrorMessage;
import solutions.viae.coreutils.domain.Response;
import solutions.viae.coreutils.utils.DateUtils;
import solutions.viae.coreutils.utils.Validator;
import solutions.viae.coreutils.utils.ValidatorKt;
import solutions.viae.databasemanagement.core.api.domain.Database;
import solutions.viae.databasemanagement.core.api.domain.DatabaseId;
import solutions.viae.databasemanagement.core.api.repositories.ReadOnlyDatabasesRepository;
import solutions.viae.requestlog.core.domain.RequestLog;
import solutions.viae.requestlog.core.repositories.RequestLogsRepository;
import solutions.viae.requestlog.mongodb.repositories.MongoDbRequestLogsRepository;
import solutions.viae.requestlog.mongodb.repositories.MongoDbRequestLogsRepository$saveRequestLog$1$$special$;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsolutions/viae/requestlog/mongodb/repositories/MongoDbRequestLogsRepository;", "Lsolutions/viae/requestlog/core/repositories/RequestLogsRepository;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "databasesRepository", "Lsolutions/viae/databasemanagement/core/api/repositories/ReadOnlyDatabasesRepository;", "(Lcom/mongodb/client/MongoClient;Lsolutions/viae/databasemanagement/core/api/repositories/ReadOnlyDatabasesRepository;)V", "getRequestLogs", "Lsolutions/viae/coreutils/domain/Response;", "", "Lsolutions/viae/requestlog/core/domain/RequestLog;", "databaseId", "Lsolutions/viae/databasemanagement/core/api/domain/DatabaseId;", "after", "Ljava/time/ZonedDateTime;", "getRequestLogsFor", "userId", "", "Lsolutions/viae/requestlog/core/domain/UserId;", "saveRequestLog", "", "requestLog", "Companion", "viae-request-log-mongodb"})
public final class MongoDbRequestLogsRepository
implements RequestLogsRepository {
    private final MongoClient mongoClient;
    private final ReadOnlyDatabasesRepository databasesRepository;
    private static final String COLLECTION_NAME = "request_logs";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response<Long> saveRequestLog(@NotNull DatabaseId databaseId, @NotNull RequestLog requestLog) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)requestLog, (String)"requestLog");
        return ValidatorKt.runValid((Function1)((Function1)new Function1<Validator, Response<Long>>(this, databaseId, requestLog){
            final /* synthetic */ MongoDbRequestLogsRepository this$0;
            final /* synthetic */ DatabaseId $databaseId;
            final /* synthetic */ RequestLog $requestLog;

            @NotNull
            public final Response<Long> invoke(@NotNull Validator it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                boolean bl2 = false;
                Validator $this$with = it;
                boolean bl3 = false;
                String dbName = (String)$this$with.tryTransform((Function0)new Function0<String>(this){
                    final /* synthetic */ saveRequestLog.1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ((Database)MongoDbRequestLogsRepository.access$getDatabasesRepository$p(this.this$0.this$0).get(this.this$0.$databaseId).getData()).getName();
                    }
                }, MongoDbRequestLogsRepository.Companion.error("could not get database for " + this.$databaseId.asString(), "input-validation"));
                Document document = (Document)$this$with.tryTransform((Function0)new Function0<Document>(this){
                    final /* synthetic */ saveRequestLog.1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    @NotNull
                    public final Document invoke() {
                        return (Document)MongoDbRequestLogsRepository.Companion.toDocument(this.this$0.$requestLog).getData();
                    }
                }, MongoDbRequestLogsRepository.Companion.error("could not transform to mongodb documents", "input-validation"));
                $this$with.and(new String[]{"input-validation"}, (Function0)new Function0<Unit>($this$with, dbName, document, this){
                    final /* synthetic */ Validator $this_with;
                    final /* synthetic */ String $dbName;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ saveRequestLog.1 this$0;
                    {
                        this.$this_with = validator;
                        this.$dbName = string;
                        this.$document = document;
                        this.this$0 = var4_4;
                        super(0);
                    }

                    @Nullable
                    public final Unit invoke() {
                        return (Unit)this.$this_with.tryTransform((Function0)new Function0<Unit>(this){
                            final /* synthetic */ saveRequestLog$1$$special$$inlined$with$lambda$3 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                MongoClient mongoClient = MongoDbRequestLogsRepository.access$getMongoClient$p(this.this$0.this$0.this$0);
                                String string = this.this$0.$dbName;
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                MongoCollection mongoCollection = mongoClient.getDatabase(string).getCollection("request_logs");
                                Document document = this.this$0.$document;
                                if (document == null) {
                                    Intrinsics.throwNpe();
                                }
                                mongoCollection.insertOne((Object)document);
                            }
                        }, MongoDbRequestLogsRepository.Companion.error("could not insert request logs on database " + this.$dbName, "do-action"));
                    }
                });
                return $this$with.respond((Function0)saveRequestLog.1.2.INSTANCE);
            }
            {
                this.this$0 = mongoDbRequestLogsRepository;
                this.$databaseId = databaseId;
                this.$requestLog = requestLog;
                super(1);
            }
        }));
    }

    @NotNull
    public Response<List<RequestLog>> getRequestLogs(@NotNull DatabaseId databaseId, @NotNull ZonedDateTime after) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
        return ValidatorKt.runValid((Function1)((Function1)new Function1<Validator, Response<List<? extends RequestLog>>>(this, databaseId, after){
            final /* synthetic */ MongoDbRequestLogsRepository this$0;
            final /* synthetic */ DatabaseId $databaseId;
            final /* synthetic */ ZonedDateTime $after;

            @NotNull
            public final Response<List<RequestLog>> invoke(@NotNull Validator it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                boolean bl2 = false;
                Validator $this$with = it;
                boolean bl3 = false;
                String dbName = (String)$this$with.tryTransform((Function0)new Function0<String>(this){
                    final /* synthetic */ getRequestLogs.1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ((Database)MongoDbRequestLogsRepository.access$getDatabasesRepository$p(this.this$0.this$0).get(this.this$0.$databaseId).getData()).getName();
                    }
                }, MongoDbRequestLogsRepository.Companion.error("could not get database for " + this.$databaseId.asString(), "input-validation"));
                List documents = (List)$this$with.tryTransform((Function0)new Function0<List<? extends Document>>(dbName, this){
                    final /* synthetic */ String $dbName;
                    final /* synthetic */ getRequestLogs.1 this$0;
                    {
                        this.$dbName = string;
                        this.this$0 = var2_2;
                        super(0);
                    }

                    @NotNull
                    public final List<Document> invoke() {
                        MongoClient mongoClient = MongoDbRequestLogsRepository.access$getMongoClient$p(this.this$0.this$0);
                        String string = this.$dbName;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        return MongoDbRequestLogsRepository.Companion.getRequestLogs(mongoClient, string, this.this$0.$after, null);
                    }
                }, MongoDbRequestLogsRepository.Companion.error("could not read/filter request logs from database based upon timestamp", "transform"));
                List result2 = (List)$this$with.and(new String[]{"input-validation", "transform"}, (Function0)new Function0<List<? extends RequestLog>>($this$with, documents){
                    final /* synthetic */ Validator $this_with;
                    final /* synthetic */ List $documents;

                    @Nullable
                    public final List<RequestLog> invoke() {
                        return (List)this.$this_with.tryTransform((Function0)new Function0<List<? extends RequestLog>>(this){
                            final /* synthetic */ getRequestLogs.1.result.1 this$0;

                            @NotNull
                            public final List<RequestLog> invoke() {
                                List list = this.this$0.$documents;
                                if (list == null) {
                                    Intrinsics.throwNpe();
                                }
                                return MongoDbRequestLogsRepository.Companion.mapToRequestLogs(list);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, MongoDbRequestLogsRepository.Companion.error("could not transform request log documents to domain objects for based upon timestamp", "do-action"));
                    }
                    {
                        this.$this_with = validator;
                        this.$documents = list;
                        super(0);
                    }
                });
                return $this$with.respond((Function0)new Function0<List<? extends RequestLog>>(result2){
                    final /* synthetic */ List $result;

                    @NotNull
                    public final List<RequestLog> invoke() {
                        List list = this.$result;
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        return list;
                    }
                    {
                        this.$result = list;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = mongoDbRequestLogsRepository;
                this.$databaseId = databaseId;
                this.$after = zonedDateTime;
                super(1);
            }
        }));
    }

    @NotNull
    public Response<List<RequestLog>> getRequestLogsFor(@NotNull DatabaseId databaseId, @NotNull ZonedDateTime after, @NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        return ValidatorKt.runValid((Function1)((Function1)new Function1<Validator, Response<List<? extends RequestLog>>>(this, databaseId, after, userId){
            final /* synthetic */ MongoDbRequestLogsRepository this$0;
            final /* synthetic */ DatabaseId $databaseId;
            final /* synthetic */ ZonedDateTime $after;
            final /* synthetic */ String $userId;

            @NotNull
            public final Response<List<RequestLog>> invoke(@NotNull Validator it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                boolean bl2 = false;
                Validator $this$with = it;
                boolean bl3 = false;
                String dbName = (String)$this$with.tryTransform((Function0)new Function0<String>(this){
                    final /* synthetic */ getRequestLogsFor.1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return ((Database)MongoDbRequestLogsRepository.access$getDatabasesRepository$p(this.this$0.this$0).get(this.this$0.$databaseId).getData()).getName();
                    }
                }, MongoDbRequestLogsRepository.Companion.error("could not get database for " + this.$databaseId.asString(), "input-validation"));
                List documents = (List)$this$with.tryTransform((Function0)new Function0<List<? extends Document>>(dbName, this){
                    final /* synthetic */ String $dbName;
                    final /* synthetic */ getRequestLogsFor.1 this$0;
                    {
                        this.$dbName = string;
                        this.this$0 = var2_2;
                        super(0);
                    }

                    @NotNull
                    public final List<Document> invoke() {
                        MongoClient mongoClient = MongoDbRequestLogsRepository.access$getMongoClient$p(this.this$0.this$0);
                        String string = this.$dbName;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        return MongoDbRequestLogsRepository.Companion.getRequestLogs(mongoClient, string, this.this$0.$after, this.this$0.$userId);
                    }
                }, MongoDbRequestLogsRepository.Companion.error("could not read/filter request logs from database based upon timestamp and user", "transform"));
                List result2 = (List)$this$with.and(new String[]{"input-validation", "transform"}, (Function0)new Function0<List<? extends RequestLog>>($this$with, documents){
                    final /* synthetic */ Validator $this_with;
                    final /* synthetic */ List $documents;

                    @Nullable
                    public final List<RequestLog> invoke() {
                        return (List)this.$this_with.tryTransform((Function0)new Function0<List<? extends RequestLog>>(this){
                            final /* synthetic */ getRequestLogsFor.1.result.1 this$0;

                            @NotNull
                            public final List<RequestLog> invoke() {
                                List list = this.this$0.$documents;
                                if (list == null) {
                                    Intrinsics.throwNpe();
                                }
                                return MongoDbRequestLogsRepository.Companion.mapToRequestLogs(list);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, MongoDbRequestLogsRepository.Companion.error("could not transform request log documents to domain objects for based upon timestamp and user", "do-action"));
                    }
                    {
                        this.$this_with = validator;
                        this.$documents = list;
                        super(0);
                    }
                });
                return $this$with.respond((Function0)new Function0<List<? extends RequestLog>>(result2){
                    final /* synthetic */ List $result;

                    @NotNull
                    public final List<RequestLog> invoke() {
                        List list = this.$result;
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        return list;
                    }
                    {
                        this.$result = list;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = mongoDbRequestLogsRepository;
                this.$databaseId = databaseId;
                this.$after = zonedDateTime;
                this.$userId = string;
                super(1);
            }
        }));
    }

    public MongoDbRequestLogsRepository(@NotNull MongoClient mongoClient, @NotNull ReadOnlyDatabasesRepository databasesRepository) {
        Intrinsics.checkParameterIsNotNull((Object)mongoClient, (String)"mongoClient");
        Intrinsics.checkParameterIsNotNull((Object)databasesRepository, (String)"databasesRepository");
        this.mongoClient = mongoClient;
        this.databasesRepository = databasesRepository;
    }

    public static final /* synthetic */ ReadOnlyDatabasesRepository access$getDatabasesRepository$p(MongoDbRequestLogsRepository $this) {
        return $this.databasesRepository;
    }

    public static final /* synthetic */ MongoClient access$getMongoClient$p(MongoDbRequestLogsRepository $this) {
        return $this.mongoClient;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0012J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsolutions/viae/requestlog/mongodb/repositories/MongoDbRequestLogsRepository$Companion;", "", "()V", "COLLECTION_NAME", "", "error", "Lsolutions/viae/coreutils/domain/ErrorMessage;", "message", "errorGroup", "getRequestLogs", "", "Lorg/bson/Document;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "dbName", "after", "Ljava/time/ZonedDateTime;", "userId", "Lsolutions/viae/requestlog/core/domain/UserId;", "mapToRequestLogs", "Lsolutions/viae/requestlog/core/domain/RequestLog;", "documents", "toDocument", "Lsolutions/viae/coreutils/domain/Response;", "requestLog", "viae-request-log-mongodb"})
    public static final class Companion {
        @NotNull
        public final Response<Document> toDocument(@NotNull RequestLog requestLog) {
            Intrinsics.checkParameterIsNotNull((Object)requestLog, (String)"requestLog");
            Document document = new Document().append("id", (Object)requestLog.getId()).append("groupId", (Object)requestLog.getGroupId()).append("url", (Object)requestLog.getUrl()).append("path", (Object)requestLog.getPath()).append("method", (Object)requestLog.getMethod()).append("remoteAddress", (Object)requestLog.getRemoteAddress()).append("tookInMilliSeconds", (Object)requestLog.getTookInMilliSeconds()).append("userAgent", (Object)requestLog.getUserAgent()).append("user", (Object)requestLog.getUser()).append("xForwardedFor", (Object)requestLog.getXForwardedFor()).append("created", (Object)DateUtils.Companion.toString(requestLog.getCreated())).append("errorMessage", (Object)requestLog.getErrorMessage()).append("responseCode", (Object)requestLog.getResponseCode()).append("freeMessage", (Object)requestLog.getFreeMessage()).append("isFreeMessageLog", (Object)requestLog.isFreeMessageLog()).append("payloadSize", (Object)requestLog.getPayloadSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"Document()\n             \u2026, requestLog.payloadSize)");
            return Response.Companion.success((Object)document);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RequestLog> mapToRequestLogs(@NotNull List<? extends Document> documents) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(documents, (String)"documents");
            Iterable $this$map$iv = documents;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                void d;
                Document document = (Document)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string10 = d.getString((Object)"id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"d.getString(\"id\")");
                String string11 = d.getString((Object)"groupId");
                String string12 = d.getString((Object)"url");
                Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"d.getString(\"url\")");
                String string13 = d.getString((Object)"path");
                Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"d.getString(\"path\")");
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"method"), (String)"d.getString(\"method\")");
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"remoteAddress"), (String)"d.getString(\"remoteAddress\")");
                Long l = d.getLong((Object)"tookInMilliSeconds");
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"d.getLong(\"tookInMilliSeconds\")");
                long l2 = l;
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"userAgent"), (String)"d.getString(\"userAgent\")");
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"user"), (String)"d.getString(\"user\")");
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"xForwardedFor"), (String)"d.getString(\"xForwardedFor\")");
                String string14 = d.getString((Object)"created");
                Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"d.getString(\"created\")");
                ZonedDateTime zonedDateTime = DateUtils.Companion.toTimeStamp(string14);
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"errorMessage"), (String)"d.getString(\"errorMessage\")");
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"responseCode"), (String)"d.getString(\"responseCode\")");
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"freeMessage"), (String)"d.getString(\"freeMessage\")");
                Boolean bl2 = d.getBoolean((Object)"isFreeMessageLog");
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"d.getBoolean(\"isFreeMessageLog\")");
                boolean bl3 = bl2;
                Intrinsics.checkExpressionValueIsNotNull((Object)d.getString((Object)"payloadSize"), (String)"d.getString(\"payloadSize\")");
                boolean bl4 = bl3;
                ZonedDateTime zonedDateTime2 = zonedDateTime;
                long l3 = l2;
                RequestLog requestLog = new RequestLog(string10, string11, string12, string13, string9, string8, string7, l3, string6, string5, string4, zonedDateTime2, string3, string2, bl4, string);
                collection.add(requestLog);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<Document> getRequestLogs(@NotNull MongoClient mongoClient, @NotNull String dbName, @NotNull ZonedDateTime after, @Nullable String userId) {
            Intrinsics.checkParameterIsNotNull((Object)mongoClient, (String)"mongoClient");
            Intrinsics.checkParameterIsNotNull((Object)dbName, (String)"dbName");
            Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
            Bson bson = userId == null ? Filters.gte((String)"created", (Object)DateUtils.Companion.toString(after)) : Filters.and((Bson[])new Bson[]{Filters.gte((String)"created", (Object)DateUtils.Companion.toString(after)), Filters.eq((String)"user", (Object)userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)bson, (String)"if (userId == null) {\n  \u2026          )\n            }");
            Bson filter = bson;
            FindIterable findIterable = mongoClient.getDatabase(dbName).getCollection(MongoDbRequestLogsRepository.COLLECTION_NAME).find(filter);
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"mongoClient.getDatabase(\u2026            .find(filter)");
            return CollectionsKt.toList((Iterable)((Iterable)findIterable));
        }

        @NotNull
        public final ErrorMessage error(@NotNull String message, @NotNull String errorGroup) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)errorGroup, (String)"errorGroup");
            return new ErrorMessage(Reflection.getOrCreateKotlinClass(MongoDbRequestLogsRepository.class), message, errorGroup, null, 8, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

