/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.integration;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.attributes.Attribute;
import space.kscience.attributes.AttributesBuilder;
import space.kscience.kmath.integration.Integrand;
import space.kscience.kmath.integration.IntegrandCallsPerformed;
import space.kscience.kmath.integration.IntegrandKt;
import space.kscience.kmath.integration.IntegrandMaxCalls;
import space.kscience.kmath.integration.IntegrandValue;
import space.kscience.kmath.integration.IntegrationRange;
import space.kscience.kmath.integration.Integrator;
import space.kscience.kmath.integration.UnivariateIntegrand;
import space.kscience.kmath.integration.UnivariateIntegrandKt;
import space.kscience.kmath.integration.UnivariateIntegrandRanges;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002*\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00040\u0001j\f\u0012\b\u0012\u00060\u0002j\u0002`\u0003`\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J4\u0010\b\u001a\u00020\u00022\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00042\u0010\u0010\n\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00042\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Lspace/kscience/kmath/integration/DoubleSimpsonIntegrator;", "Lspace/kscience/kmath/integration/Integrator;", "", "Lspace/kscience/kmath/structures/Float64;", "Lspace/kscience/kmath/integration/UnivariateIntegrand;", "Lspace/kscience/kmath/integration/UnivariateIntegrator;", "<init>", "()V", "integrateRange", "integrand", "range", "Lkotlin/ranges/ClosedRange;", "numPoints", "", "integrate", "kmath-functions"})
@SourceDebugExtension(value={"SMAP\nSimpsonIntegrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpsonIntegrator.kt\nspace/kscience/kmath/integration/DoubleSimpsonIntegrator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class DoubleSimpsonIntegrator
implements Integrator<Double, UnivariateIntegrand<Double>> {
    @NotNull
    public static final DoubleSimpsonIntegrator INSTANCE = new DoubleSimpsonIntegrator();

    private DoubleSimpsonIntegrator() {
    }

    private final double integrateRange(UnivariateIntegrand<Double> integrand, ClosedRange<Double> range, int numPoints) {
        double h = (((Number)((Object)range.getEndInclusive())).doubleValue() - ((Number)((Object)range.getStart())).doubleValue()) / (double)(numPoints - 1);
        int n = 0;
        double[] dArray = new double[numPoints];
        while (n < numPoints) {
            int n2 = n++;
            dArray[n2] = ((Number)integrand.getFunction().invoke((Object)(((Number)((Object)range.getStart())).doubleValue() + (double)n2 * h))).doubleValue();
        }
        double[] values = dArray;
        double res = 0.0;
        res += DoubleSimpsonIntegrator.integrateRange$simpson(h, values, 1) / 1.5;
        int n3 = values.length - 2;
        for (int i = 2; i < n3; ++i) {
            res += DoubleSimpsonIntegrator.integrateRange$simpson(h, values, i) / (double)2;
        }
        return res += DoubleSimpsonIntegrator.integrateRange$simpson(h, values, values.length - 2) / 1.5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UnivariateIntegrand<Double> integrate(@NotNull UnivariateIntegrand<Double> integrand) {
        UnivariateIntegrand<Double> univariateIntegrand;
        Intrinsics.checkNotNullParameter(integrand, (String)"integrand");
        UnivariateIntegrandRanges ranges = (UnivariateIntegrandRanges)IntegrandKt.get((Integrand)integrand, UnivariateIntegrandRanges.Companion);
        if (ranges != null) {
            Iterable iterable = ranges.getRanges();
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                Pair pair = (Pair)t;
                double d2 = d;
                boolean bl = false;
                double d3 = INSTANCE.integrateRange(integrand, (ClosedRange<Double>)((ClosedRange)it.getFirst()), ((Number)it.getSecond()).intValue());
                d = d2 + d3;
            }
            double res = d;
            univariateIntegrand = UnivariateIntegrandKt.withAttributes(integrand, arg_0 -> DoubleSimpsonIntegrator.integrate$lambda$2(res, integrand, ranges, arg_0));
        } else {
            Integer n = (Integer)IntegrandKt.get((Integrand)integrand, IntegrandMaxCalls.INSTANCE);
            int numPoints = n != null ? n : 100;
            if (!(numPoints >= 4)) {
                boolean $i$a$-require-DoubleSimpsonIntegrator$integrate$32 = false;
                String $i$a$-require-DoubleSimpsonIntegrator$integrate$32 = "Simpson integrator requires at least 4 nodes";
                throw new IllegalArgumentException($i$a$-require-DoubleSimpsonIntegrator$integrate$32.toString());
            }
            ClosedRange closedRange = (ClosedRange)IntegrandKt.get((Integrand)integrand, IntegrationRange.INSTANCE);
            if (closedRange == null) {
                closedRange = (ClosedRange)RangesKt.rangeTo((double)0.0, (double)1.0);
            }
            ClosedRange range = closedRange;
            double res = this.integrateRange(integrand, (ClosedRange<Double>)range, numPoints);
            univariateIntegrand = UnivariateIntegrandKt.withAttributes(integrand, arg_0 -> DoubleSimpsonIntegrator.integrate$lambda$4(res, integrand, numPoints, arg_0));
        }
        return univariateIntegrand;
    }

    private static final double integrateRange$simpson(double h, double[] values, int index) {
        return h / (double)3 * (values[index - 1] + (double)4 * values[index] + values[index + 1]);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit integrate$lambda$2(double $res, UnivariateIntegrand $integrand, UnivariateIntegrandRanges $ranges, AttributesBuilder $this$withAttributes) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$withAttributes, (String)"$this$withAttributes");
        $this$withAttributes.invoke((Attribute)IntegrandValue.Companion, (Object)$res);
        Iterable iterable = $ranges.getRanges();
        int n2 = IntegrandKt.getCalls($integrand);
        Attribute attribute = IntegrandCallsPerformed.INSTANCE;
        AttributesBuilder attributesBuilder = $this$withAttributes;
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            n = n3;
            boolean bl = false;
            int n4 = ((Number)it.getSecond()).intValue();
            n3 = n + n4;
        }
        n = n3;
        attributesBuilder.invoke(attribute, (Object)(n2 + n));
        return Unit.INSTANCE;
    }

    private static final Unit integrate$lambda$4(double $res, UnivariateIntegrand $integrand, int $numPoints, AttributesBuilder $this$withAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$withAttributes, (String)"$this$withAttributes");
        $this$withAttributes.invoke((Attribute)IntegrandValue.Companion, (Object)$res);
        $this$withAttributes.invoke((Attribute)IntegrandCallsPerformed.INSTANCE, (Object)(IntegrandKt.getCalls($integrand) + $numPoints));
        return Unit.INSTANCE;
    }
}

