/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.integration;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.attributes.Attribute;
import space.kscience.attributes.AttributesBuilder;
import space.kscience.kmath.integration.GaussIntegratorRuleFactory;
import space.kscience.kmath.integration.GaussIntegratorRuleFactoryKt;
import space.kscience.kmath.integration.GaussLegendreRuleFactory;
import space.kscience.kmath.integration.Integrand;
import space.kscience.kmath.integration.IntegrandCallsPerformed;
import space.kscience.kmath.integration.IntegrandKt;
import space.kscience.kmath.integration.IntegrandMaxCalls;
import space.kscience.kmath.integration.IntegrandValue;
import space.kscience.kmath.integration.IntegrationRange;
import space.kscience.kmath.integration.Integrator;
import space.kscience.kmath.integration.UnivariateIntegrand;
import space.kscience.kmath.integration.UnivariateIntegrandKt;
import space.kscience.kmath.integration.UnivariateIntegrandRanges;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferKt;
import space.kscience.kmath.structures.Float64Buffer;
import space.kscience.kmath.structures.Float64BufferKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003j\b\u0012\u0004\u0012\u0002H\u0001`\u0005:\u0001\u0013B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\f\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lspace/kscience/kmath/integration/GaussIntegrator;", "T", "", "Lspace/kscience/kmath/integration/Integrator;", "Lspace/kscience/kmath/integration/UnivariateIntegrand;", "Lspace/kscience/kmath/integration/UnivariateIntegrator;", "algebra", "Lspace/kscience/kmath/operations/Field;", "<init>", "(Lspace/kscience/kmath/operations/Field;)V", "getAlgebra", "()Lspace/kscience/kmath/operations/Field;", "buildRule", "Lkotlin/Pair;", "Lspace/kscience/kmath/structures/Buffer;", "", "Lspace/kscience/kmath/structures/Float64;", "integrand", "integrate", "Companion", "kmath-functions"})
@SourceDebugExtension(value={"SMAP\nGaussIntegrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GaussIntegrator.kt\nspace/kscience/kmath/integration/GaussIntegrator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class GaussIntegrator<T>
implements Integrator<T, UnivariateIntegrand<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Field<T> algebra;

    public GaussIntegrator(@NotNull Field<T> algebra) {
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        this.algebra = algebra;
    }

    @NotNull
    public final Field<T> getAlgebra() {
        return this.algebra;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Buffer<Double>, Buffer<Double>> buildRule(UnivariateIntegrand<T> integrand) {
        UnivariateIntegrandRanges predefinedRanges;
        GaussIntegratorRuleFactory factory;
        GaussIntegratorRuleFactory gaussIntegratorRuleFactory = (GaussIntegratorRuleFactory)IntegrandKt.get((Integrand)integrand, GaussIntegratorRuleFactory.Companion);
        if (gaussIntegratorRuleFactory == null) {
            gaussIntegratorRuleFactory = factory = (GaussIntegratorRuleFactory)GaussLegendreRuleFactory.INSTANCE;
        }
        if ((predefinedRanges = (UnivariateIntegrandRanges)IntegrandKt.get((Integrand)integrand, UnivariateIntegrandRanges.Companion)) == null || predefinedRanges.getRanges().isEmpty()) {
            Integer n = (Integer)IntegrandKt.get((Integrand)integrand, IntegrandMaxCalls.INSTANCE);
            int numPoints = n != null ? n : 100;
            ClosedRange closedRange = (ClosedRange)IntegrandKt.get((Integrand)integrand, IntegrationRange.INSTANCE);
            if (closedRange == null) {
                closedRange = (ClosedRange)RangesKt.rangeTo((double)0.0, (double)1.0);
            }
            ClosedRange range = closedRange;
            return GaussIntegratorRuleFactoryKt.build(factory, numPoints, (ClosedRange<Double>)range);
        }
        List<Pair<ClosedRange<Double>, Integer>> ranges = predefinedRanges.getRanges();
        int counter = 0;
        Iterable iterable = ranges;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((Number)it.getSecond()).intValue();
            n = n2 + n3;
        }
        int length = n;
        double[] pointsArray = new double[length];
        double[] weightsArray = new double[length];
        for (Pair pair : ranges) {
            Pair<Buffer<Double>, Buffer<Double>> rule = GaussIntegratorRuleFactoryKt.build(factory, ((Number)pair.getSecond()).intValue(), (ClosedRange<Double>)((ClosedRange)pair.getFirst()));
            int n4 = ((Buffer)rule.getFirst()).getSize();
            int n5 = 0;
            while (n5 < n4) {
                int i = n5++;
                boolean bl = false;
                pointsArray[counter] = ((Number)((Buffer)rule.getFirst()).get(i)).doubleValue();
                weightsArray[counter] = ((Number)((Buffer)rule.getSecond()).get(i)).doubleValue();
                ++counter;
            }
        }
        return TuplesKt.to((Object)Float64Buffer.box-impl((double[])Float64BufferKt.asBuffer((double[])pointsArray)), (Object)Float64Buffer.box-impl((double[])Float64BufferKt.asBuffer((double[])weightsArray)));
    }

    @Override
    @NotNull
    public UnivariateIntegrand<T> integrate(@NotNull UnivariateIntegrand<T> integrand) {
        Intrinsics.checkNotNullParameter(integrand, (String)"integrand");
        Field<T> $this$integrate_u24lambda_u243 = this.algebra;
        boolean bl = false;
        Function1<Double, T> f = integrand.getFunction();
        Pair<Buffer<Double>, Buffer<Double>> pair = this.buildRule(integrand);
        Buffer points = (Buffer)pair.component1();
        Buffer weights = (Buffer)pair.component2();
        Ref.ObjectRef res = new Ref.ObjectRef();
        res.element = $this$integrate_u24lambda_u243.getZero();
        Object c = $this$integrate_u24lambda_u243.getZero();
        IntRange intRange = BufferKt.getIndices((Buffer)points);
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                double x = ((Number)points.get(i)).doubleValue();
                double weight = ((Number)weights.get(i)).doubleValue();
                Object y = $this$integrate_u24lambda_u243.minus($this$integrate_u24lambda_u243.times((Number)weight, f.invoke((Object)x)), c);
                Object t = $this$integrate_u24lambda_u243.plus(res.element, y);
                c = $this$integrate_u24lambda_u243.minus($this$integrate_u24lambda_u243.minus(t, res.element), y);
                res.element = t;
                if (i == n) break;
                ++i;
            }
        }
        return UnivariateIntegrandKt.withAttributes(integrand, arg_0 -> GaussIntegrator.integrate$lambda$3$lambda$2(res, integrand, points, arg_0));
    }

    private static final Unit integrate$lambda$3$lambda$2(Ref.ObjectRef $res, UnivariateIntegrand $integrand, Buffer $points, AttributesBuilder $this$withAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$withAttributes, (String)"$this$withAttributes");
        $this$withAttributes.invoke((Attribute)IntegrandValue.Companion, $res.element);
        $this$withAttributes.invoke((Attribute)IntegrandCallsPerformed.INSTANCE, (Object)(IntegrandKt.getCalls($integrand) + $points.getSize()));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lspace/kscience/kmath/integration/GaussIntegrator$Companion;", "", "<init>", "()V", "kmath-functions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

