/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.integration;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.integration.GaussIntegratorRuleFactory;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.Float64Buffer;
import space.kscience.kmath.structures.Float64BufferKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\f\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002J0\u0010\u000e\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002J0\u0010\u000f\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016Rj\u0010\u0004\u001a^\u0012\u0004\u0012\u00020\u0006\u0012$\u0012\"\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00070\u0005j.\u0012\u0004\u0012\u00020\u0006\u0012$\u0012\"\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lspace/kscience/kmath/integration/GaussLegendreRuleFactory;", "Lspace/kscience/kmath/integration/GaussIntegratorRuleFactory;", "<init>", "()V", "cache", "Ljava/util/HashMap;", "", "Lkotlin/Pair;", "Lspace/kscience/kmath/structures/Buffer;", "", "Lspace/kscience/kmath/structures/Float64;", "Lkotlin/collections/HashMap;", "getOrBuildRule", "numPoints", "buildRule", "build", "toString", "", "kmath-functions"})
@SourceDebugExtension(value={"SMAP\nGaussIntegratorRuleFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GaussIntegratorRuleFactory.kt\nspace/kscience/kmath/integration/GaussLegendreRuleFactory\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,169:1\n381#2,7:170\n*S KotlinDebug\n*F\n+ 1 GaussIntegratorRuleFactory.kt\nspace/kscience/kmath/integration/GaussLegendreRuleFactory\n*L\n62#1:170,7\n*E\n"})
public final class GaussLegendreRuleFactory
implements GaussIntegratorRuleFactory {
    @NotNull
    public static final GaussLegendreRuleFactory INSTANCE = new GaussLegendreRuleFactory();
    @NotNull
    private static final HashMap<Integer, Pair<Buffer<Double>, Buffer<Double>>> cache = new HashMap();

    private GaussLegendreRuleFactory() {
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Buffer<Double>, Buffer<Double>> getOrBuildRule(int numPoints) {
        Object object;
        void $this$getOrPut$iv;
        Map map = cache;
        Integer key$iv = numPoints;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Pair<Buffer<Double>, Buffer<Double>> answer$iv = INSTANCE.buildRule(numPoints);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Pair)object;
    }

    private final Pair<Buffer<Double>, Buffer<Double>> buildRule(int numPoints) {
        if (numPoints == 1) {
            double[] dArray = new double[]{0.0};
            Float64Buffer float64Buffer = Float64Buffer.box-impl((double[])Float64BufferKt.Float64Buffer((double[])dArray));
            dArray = new double[]{0.0};
            return new Pair((Object)float64Buffer, (Object)Float64Buffer.box-impl((double[])Float64BufferKt.Float64Buffer((double[])dArray)));
        }
        Buffer previousPoints = (Buffer)this.getOrBuildRule(numPoints - 1).getFirst();
        double[] points = new double[numPoints];
        double[] weights = new double[numPoints];
        int iMax = numPoints / 2;
        for (int i = 0; i < iMax; ++i) {
            double a = i == 0 ? -1.0 : ((Number)previousPoints.get(i - 1)).doubleValue();
            double b = iMax == 1 ? 1.0 : ((Number)previousPoints.get(i)).doubleValue();
            double pma = 1.0;
            double pa = a;
            double pmb = 1.0;
            double pb = b;
            for (int j = 1; j < numPoints; ++j) {
                int twoJP1 = 2 * j + 1;
                int jP1 = j + 1;
                double ppa = ((double)twoJP1 * a * pa - (double)j * pma) / (double)jP1;
                double ppb = ((double)twoJP1 * b * pb - (double)j * pmb) / (double)jP1;
                pma = pa;
                pa = ppa;
                pmb = pb;
                pb = ppb;
            }
            double c = 0.5 * (a + b);
            double pmc = 1.0;
            double pc = c;
            boolean done = false;
            while (!done) {
                done = b - a <= Math.ulp(c);
                pmc = 1.0;
                pc = c;
                for (int j = 1; j < numPoints; ++j) {
                    double ppc = ((double)(2 * j + 1) * c * pc - (double)j * pmc) / (double)(j + 1);
                    pmc = pc;
                    pc = ppc;
                }
                if (done) continue;
                if (pa * pc <= 0.0) {
                    b = c;
                } else {
                    a = c;
                    pa = pc;
                }
                c = 0.5 * (a + b);
            }
            double d = (double)numPoints * (pmc - c * pc);
            double w = (double)2 * (1.0 - c * c) / (d * d);
            points[i] = c;
            weights[i] = w;
            int idx = numPoints - i - 1;
            points[idx] = -c;
            weights[idx] = w;
        }
        if (numPoints % 2 != 0) {
            double pmc = 1.0;
            for (int j = 1; j < numPoints; j += 2) {
                pmc = (double)(-j) * pmc / (double)(j + 1);
            }
            double d = (double)numPoints * pmc;
            double w = (double)2 / (d * d);
            points[iMax] = 0.0;
            weights[iMax] = w;
        }
        return new Pair((Object)Float64Buffer.box-impl((double[])Float64BufferKt.asBuffer((double[])points)), (Object)Float64Buffer.box-impl((double[])Float64BufferKt.asBuffer((double[])weights)));
    }

    @Override
    @NotNull
    public Pair<Buffer<Double>, Buffer<Double>> build(int numPoints) {
        return this.getOrBuildRule(numPoints);
    }

    @NotNull
    public String toString() {
        return "GaussLegendreRule";
    }
}

