/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.attributes.Attribute;
import space.kscience.attributes.AttributesBuilder;
import space.kscience.kmath.UnstableKMathAPI;
import space.kscience.kmath.integration.Integrand;
import space.kscience.kmath.integration.IntegrandCallsPerformed;
import space.kscience.kmath.integration.IntegrandKt;
import space.kscience.kmath.integration.IntegrandMaxCalls;
import space.kscience.kmath.integration.IntegrandValue;
import space.kscience.kmath.integration.IntegrationRange;
import space.kscience.kmath.integration.Integrator;
import space.kscience.kmath.integration.UnivariateIntegrand;
import space.kscience.kmath.integration.UnivariateIntegrandKt;
import space.kscience.kmath.integration.UnivariateIntegrandRanges;
import space.kscience.kmath.operations.Algebra;
import space.kscience.kmath.operations.AlgebraExtensionsKt;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.operations.Group;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003j\b\u0012\u0004\u0012\u0002H\u0001`\u0005B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\f\u001a\u00028\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lspace/kscience/kmath/integration/SimpsonIntegrator;", "T", "", "Lspace/kscience/kmath/integration/Integrator;", "Lspace/kscience/kmath/integration/UnivariateIntegrand;", "Lspace/kscience/kmath/integration/UnivariateIntegrator;", "algebra", "Lspace/kscience/kmath/operations/Field;", "<init>", "(Lspace/kscience/kmath/operations/Field;)V", "getAlgebra", "()Lspace/kscience/kmath/operations/Field;", "integrateRange", "integrand", "range", "Lkotlin/ranges/ClosedRange;", "", "Lspace/kscience/kmath/structures/Float64;", "numPoints", "", "(Lspace/kscience/kmath/integration/UnivariateIntegrand;Lkotlin/ranges/ClosedRange;I)Ljava/lang/Object;", "integrate", "kmath-functions"})
@UnstableKMathAPI
@SourceDebugExtension(value={"SMAP\nSimpsonIntegrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpsonIntegrator.kt\nspace/kscience/kmath/integration/SimpsonIntegrator\n+ 2 Algebra.kt\nspace/kscience/kmath/operations/AlgebraKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n126#2:122\n1557#3:123\n1628#3,3:124\n1#4:127\n*S KotlinDebug\n*F\n+ 1 SimpsonIntegrator.kt\nspace/kscience/kmath/integration/SimpsonIntegrator\n*L\n29#1:122\n51#1:123\n51#1:124,3\n*E\n"})
public final class SimpsonIntegrator<T>
implements Integrator<T, UnivariateIntegrand<T>> {
    @NotNull
    private final Field<T> algebra;

    public SimpsonIntegrator(@NotNull Field<T> algebra) {
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        this.algebra = algebra;
    }

    @NotNull
    public final Field<T> getAlgebra() {
        return this.algebra;
    }

    /*
     * WARNING - void declaration
     */
    private final T integrateRange(UnivariateIntegrand<T> integrand, ClosedRange<Double> range, int numPoints) {
        int n;
        Algebra $this$invoke$iv = (Algebra)this.algebra;
        boolean $i$f$invoke = false;
        Field $this$integrateRange_u24lambda_u241 = (Field)$this$invoke$iv;
        boolean bl = false;
        double h = (((Number)((Object)range.getEndInclusive())).doubleValue() - ((Number)((Object)range.getStart())).doubleValue()) / (double)(numPoints - 1);
        ArrayList<Object> arrayList = new ArrayList<Object>(numPoints);
        int n2 = 0;
        while (n2 < numPoints) {
            void i;
            int n3 = n = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl2 = false;
            arrayList2.add(integrand.getFunction().invoke((Object)(((Number)((Object)range.getStart())).doubleValue() + (double)i * h)));
        }
        List values = arrayList;
        Object res = $this$integrateRange_u24lambda_u241.getZero();
        res = $this$integrateRange_u24lambda_u241.plus(res, $this$integrateRange_u24lambda_u241.div(SimpsonIntegrator.integrateRange$lambda$1$simpson($this$integrateRange_u24lambda_u241, h, values, 1), (Number)1.5));
        n = values.size() - 2;
        for (int i = 2; i < n; ++i) {
            res = $this$integrateRange_u24lambda_u241.plus(res, $this$integrateRange_u24lambda_u241.div(SimpsonIntegrator.integrateRange$lambda$1$simpson($this$integrateRange_u24lambda_u241, h, values, i), (Number)2));
        }
        res = $this$integrateRange_u24lambda_u241.plus(res, $this$integrateRange_u24lambda_u241.div(SimpsonIntegrator.integrateRange$lambda$1$simpson($this$integrateRange_u24lambda_u241, h, values, values.size() - 2), (Number)1.5));
        return (T)res;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UnivariateIntegrand<T> integrate(@NotNull UnivariateIntegrand<T> integrand) {
        UnivariateIntegrand<T> univariateIntegrand;
        Intrinsics.checkNotNullParameter(integrand, (String)"integrand");
        UnivariateIntegrandRanges ranges = (UnivariateIntegrandRanges)IntegrandKt.get((Integrand)integrand, UnivariateIntegrandRanges.Companion);
        if (ranges != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ranges.getRanges();
            Group group = (Group)this.algebra;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.integrateRange(integrand, (ClosedRange<Double>)((ClosedRange)it.getFirst()), ((Number)it.getSecond()).intValue()));
            }
            Object res = AlgebraExtensionsKt.sum((Group)group, (Iterable)((List)destination$iv$iv));
            univariateIntegrand = UnivariateIntegrandKt.withAttributes(integrand, arg_0 -> SimpsonIntegrator.integrate$lambda$4(res, integrand, ranges, arg_0));
        } else {
            Integer n = (Integer)IntegrandKt.get((Integrand)integrand, IntegrandMaxCalls.INSTANCE);
            int numPoints = n != null ? n : 100;
            if (!(numPoints >= 4)) {
                boolean $i$a$-require-SimpsonIntegrator$integrate$32 = false;
                String $i$a$-require-SimpsonIntegrator$integrate$32 = "Simpson integrator requires at least 4 nodes";
                throw new IllegalArgumentException($i$a$-require-SimpsonIntegrator$integrate$32.toString());
            }
            ClosedRange closedRange = (ClosedRange)IntegrandKt.get((Integrand)integrand, IntegrationRange.INSTANCE);
            if (closedRange == null) {
                closedRange = (ClosedRange)RangesKt.rangeTo((double)0.0, (double)1.0);
            }
            ClosedRange range = closedRange;
            T res = this.integrateRange(integrand, (ClosedRange<Double>)range, numPoints);
            univariateIntegrand = UnivariateIntegrandKt.withAttributes(integrand, arg_0 -> SimpsonIntegrator.integrate$lambda$6(res, integrand, numPoints, arg_0));
        }
        return univariateIntegrand;
    }

    private static final <T> T integrateRange$lambda$1$simpson(Field<T> $this_algebra, double h, List<? extends T> values, int index) {
        return (T)$this_algebra.times((Number)(h / (double)3), $this_algebra.plus($this_algebra.plus(values.get(index - 1), $this_algebra.times((Number)4, values.get(index))), values.get(index + 1)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit integrate$lambda$4(Object $res, UnivariateIntegrand $integrand, UnivariateIntegrandRanges $ranges, AttributesBuilder $this$withAttributes) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$withAttributes, (String)"$this$withAttributes");
        $this$withAttributes.invoke((Attribute)IntegrandValue.Companion, $res);
        Iterable iterable = $ranges.getRanges();
        int n2 = IntegrandKt.getCalls($integrand);
        Attribute attribute = IntegrandCallsPerformed.INSTANCE;
        AttributesBuilder attributesBuilder = $this$withAttributes;
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            n = n3;
            boolean bl = false;
            int n4 = ((Number)it.getSecond()).intValue();
            n3 = n + n4;
        }
        n = n3;
        attributesBuilder.invoke(attribute, (Object)(n2 + n));
        return Unit.INSTANCE;
    }

    private static final Unit integrate$lambda$6(Object $res, UnivariateIntegrand $integrand, int $numPoints, AttributesBuilder $this$withAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$withAttributes, (String)"$this$withAttributes");
        $this$withAttributes.invoke((Attribute)IntegrandValue.Companion, $res);
        $this$withAttributes.invoke((Attribute)IntegrandCallsPerformed.INSTANCE, (Object)(IntegrandKt.getCalls($integrand) + $numPoints));
        return Unit.INSTANCE;
    }
}

