/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.interpolation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.data.XYColumnarData;
import space.kscience.kmath.functions.PiecewiseBuilder;
import space.kscience.kmath.functions.PiecewiseKt;
import space.kscience.kmath.functions.PiecewisePolynomial;
import space.kscience.kmath.functions.Polynomial;
import space.kscience.kmath.functions.PolynomialConstructorsKt;
import space.kscience.kmath.interpolation.LinearInterpolatorKt;
import space.kscience.kmath.interpolation.PolynomialInterpolator;
import space.kscience.kmath.operations.Algebra;
import space.kscience.kmath.operations.Field;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\rH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lspace/kscience/kmath/interpolation/LinearInterpolator;", "T", "", "Lspace/kscience/kmath/interpolation/PolynomialInterpolator;", "algebra", "Lspace/kscience/kmath/operations/Field;", "<init>", "(Lspace/kscience/kmath/operations/Field;)V", "getAlgebra", "()Lspace/kscience/kmath/operations/Field;", "interpolatePolynomials", "Lspace/kscience/kmath/functions/PiecewisePolynomial;", "points", "Lspace/kscience/kmath/data/XYColumnarData;", "kmath-functions"})
@SourceDebugExtension(value={"SMAP\nLinearInterpolator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearInterpolator.kt\nspace/kscience/kmath/interpolation/LinearInterpolator\n+ 2 Algebra.kt\nspace/kscience/kmath/operations/AlgebraKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n126#2:45\n1#3:46\n*S KotlinDebug\n*F\n+ 1 LinearInterpolator.kt\nspace/kscience/kmath/interpolation/LinearInterpolator\n*L\n27#1:45\n*E\n"})
public final class LinearInterpolator<T extends Comparable<? super T>>
implements PolynomialInterpolator<T> {
    @NotNull
    private final Field<T> algebra;

    public LinearInterpolator(@NotNull Field<T> algebra) {
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        this.algebra = algebra;
    }

    @Override
    @NotNull
    public Field<T> getAlgebra() {
        return this.algebra;
    }

    @Override
    @NotNull
    public PiecewisePolynomial<T> interpolatePolynomials(@NotNull XYColumnarData<? extends T, ? extends T, ? extends T> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Algebra $this$invoke$iv = (Algebra)this.getAlgebra();
        boolean $i$f$invoke = false;
        Field $this$interpolatePolynomials_u24lambda_u242 = (Field)$this$invoke$iv;
        boolean bl = false;
        if (!(points.getSize() > 0)) {
            boolean bl2 = false;
            String string = "Point array should not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        LinearInterpolatorKt.insureSorted(points);
        return PiecewiseKt.PiecewisePolynomial((Comparable)points.getX().get(0), arg_0 -> LinearInterpolator.interpolatePolynomials$lambda$2$lambda$1(points, $this$interpolatePolynomials_u24lambda_u242, arg_0));
    }

    private static final Unit interpolatePolynomials$lambda$2$lambda$1(XYColumnarData $points, Field $this_algebra, PiecewiseBuilder $this$PiecewisePolynomial) {
        Intrinsics.checkNotNullParameter((Object)$this$PiecewisePolynomial, (String)"$this$PiecewisePolynomial");
        int n = $points.getSize() - 1;
        for (int i = 0; i < n; ++i) {
            Comparable slope = (Comparable)$this_algebra.div($this_algebra.minus($points.getY().get(i + 1), $points.getY().get(i)), $this_algebra.minus($points.getX().get(i + 1), $points.getX().get(i)));
            Comparable comparable = (Comparable)$this_algebra.minus($points.getY().get(i), $this_algebra.times((Object)slope, $points.getX().get(i)));
            Object[] objectArray = new Comparable[]{comparable, slope};
            Polynomial polynomial = PolynomialConstructorsKt.Polynomial$default(objectArray, false, 2, null);
            $this$PiecewisePolynomial.putRight((Comparable)$points.getX().get(i + 1), polynomial);
        }
        return Unit.INSTANCE;
    }
}

