/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.interpolation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.data.XYColumnarData;
import space.kscience.kmath.functions.PiecewiseBuilder;
import space.kscience.kmath.functions.PiecewiseKt;
import space.kscience.kmath.functions.PiecewisePolynomial;
import space.kscience.kmath.functions.Polynomial;
import space.kscience.kmath.functions.PolynomialConstructorsKt;
import space.kscience.kmath.interpolation.LinearInterpolatorKt;
import space.kscience.kmath.interpolation.PolynomialInterpolator;
import space.kscience.kmath.operations.Algebra;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.structures.MutableBuffer;
import space.kscience.kmath.structures.MutableBufferFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lspace/kscience/kmath/interpolation/SplineInterpolator;", "T", "", "Lspace/kscience/kmath/interpolation/PolynomialInterpolator;", "algebra", "Lspace/kscience/kmath/operations/Field;", "bufferFactory", "Lspace/kscience/kmath/structures/MutableBufferFactory;", "<init>", "(Lspace/kscience/kmath/operations/Field;Lspace/kscience/kmath/structures/MutableBufferFactory;)V", "getAlgebra", "()Lspace/kscience/kmath/operations/Field;", "getBufferFactory", "()Lspace/kscience/kmath/structures/MutableBufferFactory;", "interpolatePolynomials", "Lspace/kscience/kmath/functions/PiecewisePolynomial;", "points", "Lspace/kscience/kmath/data/XYColumnarData;", "kmath-functions"})
@SourceDebugExtension(value={"SMAP\nSplineInterpolator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplineInterpolator.kt\nspace/kscience/kmath/interpolation/SplineInterpolator\n+ 2 Algebra.kt\nspace/kscience/kmath/operations/AlgebraKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n126#2:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 SplineInterpolator.kt\nspace/kscience/kmath/interpolation/SplineInterpolator\n*L\n32#1:84\n*E\n"})
public final class SplineInterpolator<T extends Comparable<? super T>>
implements PolynomialInterpolator<T> {
    @NotNull
    private final Field<T> algebra;
    @NotNull
    private final MutableBufferFactory<T> bufferFactory;

    public SplineInterpolator(@NotNull Field<T> algebra, @NotNull MutableBufferFactory<T> bufferFactory) {
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        Intrinsics.checkNotNullParameter(bufferFactory, (String)"bufferFactory");
        this.algebra = algebra;
        this.bufferFactory = bufferFactory;
    }

    public /* synthetic */ SplineInterpolator(Field field, MutableBufferFactory mutableBufferFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mutableBufferFactory = field.getBufferFactory();
        }
        this(field, mutableBufferFactory);
    }

    @Override
    @NotNull
    public Field<T> getAlgebra() {
        return this.algebra;
    }

    @NotNull
    public final MutableBufferFactory<T> getBufferFactory() {
        return this.bufferFactory;
    }

    @Override
    @NotNull
    public PiecewisePolynomial<T> interpolatePolynomials(@NotNull XYColumnarData<? extends T, ? extends T, ? extends T> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Algebra $this$invoke$iv = (Algebra)this.getAlgebra();
        boolean $i$f$invoke = false;
        Field $this$interpolatePolynomials_u24lambda_u245 = (Field)$this$invoke$iv;
        boolean bl = false;
        if (!(points.getSize() >= 3)) {
            boolean $i$a$-require-SplineInterpolator$interpolatePolynomials$1$22 = false;
            String $i$a$-require-SplineInterpolator$interpolatePolynomials$1$22 = "Can't use spline interpolator with less than 3 points";
            throw new IllegalArgumentException($i$a$-require-SplineInterpolator$interpolatePolynomials$1$22.toString());
        }
        LinearInterpolatorKt.insureSorted(points);
        int n = points.getSize() - 1;
        MutableBuffer h = $this$interpolatePolynomials_u24lambda_u245.getBufferFactory().invoke(n, arg_0 -> SplineInterpolator.interpolatePolynomials$lambda$5$lambda$1($this$interpolatePolynomials_u24lambda_u245, points, arg_0));
        MutableBuffer mu = $this$interpolatePolynomials_u24lambda_u245.getBufferFactory().invoke(n, arg_0 -> SplineInterpolator.interpolatePolynomials$lambda$5$lambda$2($this$interpolatePolynomials_u24lambda_u245, arg_0));
        MutableBuffer z = $this$interpolatePolynomials_u24lambda_u245.getBufferFactory().invoke(n + 1, arg_0 -> SplineInterpolator.interpolatePolynomials$lambda$5$lambda$3($this$interpolatePolynomials_u24lambda_u245, arg_0));
        for (int i = 1; i < n; ++i) {
            Comparable g = (Comparable)$this$interpolatePolynomials_u24lambda_u245.minus($this$interpolatePolynomials_u24lambda_u245.times((Number)2.0, $this$interpolatePolynomials_u24lambda_u245.minus(points.getX().get(i + 1), points.getX().get(i - 1))), $this$interpolatePolynomials_u24lambda_u245.times(h.get(i - 1), mu.get(i - 1)));
            mu.set(i, $this$interpolatePolynomials_u24lambda_u245.div(h.get(i), (Object)g));
            z.set(i, $this$interpolatePolynomials_u24lambda_u245.div($this$interpolatePolynomials_u24lambda_u245.minus($this$interpolatePolynomials_u24lambda_u245.div($this$interpolatePolynomials_u24lambda_u245.times($this$interpolatePolynomials_u24lambda_u245.plus($this$interpolatePolynomials_u24lambda_u245.minus($this$interpolatePolynomials_u24lambda_u245.times(points.getY().get(i + 1), h.get(i - 1)), $this$interpolatePolynomials_u24lambda_u245.times(points.getY().get(i), $this$interpolatePolynomials_u24lambda_u245.minus(points.getX().get(i + 1), points.getX().get(i - 1)))), $this$interpolatePolynomials_u24lambda_u245.times(points.getY().get(i - 1), h.get(i))), (Number)3.0), $this$interpolatePolynomials_u24lambda_u245.times(h.get(i - 1), h.get(i))), $this$interpolatePolynomials_u24lambda_u245.times(h.get(i - 1), z.get(i - 1))), (Object)g));
        }
        return PiecewiseKt.PiecewisePolynomial((Comparable)points.getX().get(points.getSize() - 1), arg_0 -> SplineInterpolator.interpolatePolynomials$lambda$5$lambda$4($this$interpolatePolynomials_u24lambda_u245, n, z, mu, points, h, arg_0));
    }

    private static final Comparable interpolatePolynomials$lambda$5$lambda$1(Field $this_algebra, XYColumnarData $points, int i) {
        return (Comparable)$this_algebra.minus($points.getX().get(i + 1), $points.getX().get(i));
    }

    private static final Comparable interpolatePolynomials$lambda$5$lambda$2(Field $this_algebra, int it) {
        return (Comparable)$this_algebra.getZero();
    }

    private static final Comparable interpolatePolynomials$lambda$5$lambda$3(Field $this_algebra, int it) {
        return (Comparable)$this_algebra.getZero();
    }

    private static final Unit interpolatePolynomials$lambda$5$lambda$4(Field $this_algebra, int $n, MutableBuffer $z, MutableBuffer $mu, XYColumnarData $points, MutableBuffer $h, PiecewiseBuilder $this$PiecewisePolynomial) {
        Intrinsics.checkNotNullParameter((Object)$this$PiecewisePolynomial, (String)"$this$PiecewisePolynomial");
        Comparable cOld = (Comparable)$this_algebra.getZero();
        for (int j = $n - 1; -1 < j; --j) {
            Comparable c = (Comparable)$this_algebra.minus($z.get(j), $this_algebra.times($mu.get(j), (Object)cOld));
            Comparable a = (Comparable)$points.getY().get(j);
            Comparable b = (Comparable)$this_algebra.minus($this_algebra.div($this_algebra.minus($points.getY().get(j + 1), $points.getY().get(j)), $h.get(j)), $this_algebra.div($this_algebra.times($h.get(j), $this_algebra.plus((Object)cOld, $this_algebra.times((Number)2.0, (Object)c))), (Number)3.0));
            Comparable d = (Comparable)$this_algebra.div($this_algebra.minus((Object)cOld, (Object)c), $this_algebra.times((Number)3.0, $h.get(j)));
            Comparable x0 = (Comparable)$points.getX().get(j);
            Comparable x02 = (Comparable)$this_algebra.times((Object)x0, (Object)x0);
            Comparable x03 = (Comparable)$this_algebra.times((Object)x02, (Object)x0);
            Object[] objectArray = new Comparable[]{$this_algebra.minus($this_algebra.plus($this_algebra.minus((Object)a, $this_algebra.times((Object)b, (Object)x0)), $this_algebra.times((Object)c, (Object)x02)), $this_algebra.times((Object)d, (Object)x03)), $this_algebra.plus($this_algebra.minus((Object)b, $this_algebra.times($this_algebra.times((Number)2, (Object)c), (Object)x0)), $this_algebra.times($this_algebra.times((Number)3, (Object)d), (Object)x02)), $this_algebra.minus((Object)c, $this_algebra.times($this_algebra.times((Number)3, (Object)d), (Object)x0)), d};
            Polynomial polynomial = PolynomialConstructorsKt.Polynomial$default(objectArray, false, 2, null);
            cOld = c;
            $this$PiecewisePolynomial.putLeft(x0, polynomial);
        }
        return Unit.INSTANCE;
    }
}

