/*
 * Decompiled with CFR 0.152.
 */
package space.x9x.radp.mybatis.spring.boot.autoconfigure;

import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import space.x9x.radp.mybatis.spring.boot.env.MybatisPluginProperties;
import space.x9x.radp.spring.data.mybatis.plugin.MybatisSqlLogInterceptor;

@ConditionalOnMissingBean(value={SqlSessionFactory.class})
@ConditionalOnProperty(name={"mybatis.plugin.sql-log.enabled"})
@EnableConfigurationProperties(value={MybatisPluginProperties.class})
@Role(value=2)
@AutoConfiguration(after={DataSourceAutoConfiguration.class})
public class RadpMybatisPluginAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RadpMybatisPluginAutoConfiguration.class);
    private static final String AUTOWIRED_MYBATIS_SQL_LOG_INTERCEPTOR = "Autowired mybatisSqlLogInterceptor";
    private final MybatisPluginProperties mybatisPluginProperties;

    @Bean
    public MybatisSqlLogInterceptor mybatisSqlLogInterceptor() {
        log.debug(AUTOWIRED_MYBATIS_SQL_LOG_INTERCEPTOR);
        MybatisSqlLogInterceptor interceptor = new MybatisSqlLogInterceptor();
        interceptor.setSlownessThreshold(this.mybatisPluginProperties.getSqlLog().getSlownessThreshold());
        return interceptor;
    }

    public RadpMybatisPluginAutoConfiguration(MybatisPluginProperties mybatisPluginProperties) {
        this.mybatisPluginProperties = mybatisPluginProperties;
    }
}

