/*
 * Decompiled with CFR 0.152.
 */
package space.x9x.radp.mybatis.spring.boot.autoconfigure;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import space.x9x.radp.mybatis.spring.boot.env.MybatisPlusExtensionProperties;
import space.x9x.radp.spring.data.mybatis.autofill.AutofillMetaObjectHandler;

@Role(value=2)
@EnableConfigurationProperties(value={MybatisPlusExtensionProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, MybatisConfiguration.class})
@ConditionalOnProperty(name={"radp.mybatis-plus.extension.auto-fill.enabled"}, havingValue="true")
@AutoConfiguration(after={MybatisPlusAutoConfiguration.class})
public class RadpMybatisPlusExtensionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RadpMybatisPlusExtensionAutoConfiguration.class);
    private static final String AUTOWIRED_META_OBJECT_HANDLER = "Autowired metaObjectHandler";

    @ConditionalOnMissingBean
    @Bean
    public MetaObjectHandler metaObjectHandler(MybatisPlusExtensionProperties properties) {
        log.debug(AUTOWIRED_META_OBJECT_HANDLER);
        return new AutofillMetaObjectHandler(properties.getAutoFill().getCreatedDataFieldName(), properties.getAutoFill().getLastModifiedDateFieldName());
    }
}

