/*
 * Decompiled with CFR 0.152.
 */
package space.x9x.radp.mybatis.spring.boot.util;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.stream.Collectors;
import space.x9x.radp.commons.collections.CollectionUtils;
import space.x9x.radp.spring.framework.dto.PageParam;
import space.x9x.radp.spring.framework.dto.PageResult;
import space.x9x.radp.spring.framework.dto.SortingField;

public final class MybatisUtils {
    public static <T> Page<T> buildPage(PageParam pageParam) {
        return MybatisUtils.buildPage(pageParam, null);
    }

    public static <T> Page<T> buildPage(PageParam pageParam, Collection<SortingField> sortingFields) {
        Page page = new Page((long)pageParam.getPageIndex().intValue(), (long)pageParam.getPageSize().intValue());
        if (!CollectionUtils.isEmpty(sortingFields)) {
            page.addOrder(sortingFields.stream().map(sortingField -> "ASC".equals(sortingField.getOrder()) ? OrderItem.asc((String)StrUtil.toUnderlineCase((CharSequence)sortingField.getField())) : OrderItem.desc((String)StrUtil.toUnderlineCase((CharSequence)sortingField.getField()))).collect(Collectors.toList()));
        }
        return page;
    }

    public static <T> PageResult<T> transformPage(IPage<T> mpPage) {
        return PageResult.build((Collection)mpPage.getRecords(), (Long)mpPage.getTotal());
    }

    private MybatisUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

