#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/**
 * 实体对象；
 * <p>
 * 1. 一般和数据库持久化对象1v1的关系.(但因各自开发系统的不同，也有1vn的可能.) <br/>
 * 2. 如果是老系统改造，那么旧的库表冗余了太多的字段，可能会有nv1的情况.<br/>
 * 3. 对象名称 <code>XxxEntity</code> <br/>
 * 4. 实体对象唯一标识, 一般不使用数据库自增ID, 而是使用业务唯一标识。
 * <p>
 * 是依托于持久化层数据以领域服务功能目标为指导设计的领域对象。持久化 PO 对象是原子类对象，不具有业务语义。而实体对象是具有业务语义具有唯一标识的对象，
 * 跟随于领域服务方法的全生命周期对象。
 * <p>
 * 如：用户 PO 持久化对象，会涵盖用户的开户实体、授信实体、额度实体对象，也包括如商品下单时候的购物车实体对象。这个对象也通常是领域服务方法的入参对象。
 * </p>
 *
 * <h4>概念</h4>
 * <p><strong>实体=唯一标识+状态属性+行为动作（功能）</strong>，是 DDD 中的一个基本构建块，它代表了具有唯一标识的领域对象。实体不仅仅包含数据（状态属性），
 * 还包含了相关的行为（功能），并且它的标识在整个生命周期中保持不变。</p>
 *
 * <h4>特征</h4>
 * <ul>
 *   <li><strong>唯一标识：</strong>实体具有一个可以区分其它实体的唯一标识符。这个标识符可以是一个 ID，一个复合键或者是一个自然键，关键是它能够唯一的标识实体实例。</li>
 *   <li><strong>领域标识：</strong>实体的标识通常来源于业务领域，例如用户ID、订单ID 等。这些标识符在业务上有特定的含义，并且在系统中是唯一的。</li>
 *   <li><strong>委派标识：</strong>在某些情况下，实体的标识可能是由 ORM（对象关系映射）框架自动生成的，如数据库中的自增主键。这种标识符虽然可以唯一标识实体，但它并不直接来源于业务领域。</li>
 * </ul>
 *
 * <h4>用途</h4>
 * <ul>
 *   <li><strong>表达业务概念：</strong>实体用于在软件中表达具体的业务概念，如用户、订单、交易等。通过实体的属性和行为，可以描述这些业务对象的特征和能力。</li>
 *   <li><strong>封装业务逻辑：</strong>实体不仅仅承载数据，还封装了业务规则和逻辑。这些逻辑包括验证数据的有效性、执行业务规则，计算属性值等。这样做的目的是保证业务逻辑的集中和一致性。</li>
 *   <li><strong>保持数据一致性：</strong>实体负责维护自身的状态和数据一致性。它确保自己的属性和关联关系在任何时候都是正确和完整的，从而避免数据的不一致性。</li>
 * </ul>
 *
 * <h4>实现手段</h4>
 * <ul>
 *   <li><strong>定义实体类：</strong>在代码中定义一个类，该类包含实体的属性、构造函数、方法等。</li>
 *   <li><strong>实现唯一标识：</strong>为实体类提供一个唯一标识的属性，如 ID，并确保在实体的生命周期中这个标识保持不变。</li>
 *   <li><strong>封装行为：</strong>在实体类中实现业务逻辑的方法，这些方法可以操作实体的状态，并执行相关的业务规则。</li>
 *   <li><strong>使用 ORM 框架：</strong>利用 ORM 框架将实体映射到数据库表中，这样可以简化数据持久化的操作。</li>
 *   <li><strong>实现领域服务：</strong>对于跨实体或跨聚合的操作，可以实现领域服务来处理这些操作，而不是在实体中直接实现。</li>
 *   <li><strong>使用领域事件：</strong>当实体的状态发生变化时，可以发布领域事件。这样可以通知其它部分的系统进行相应的处理。</li>
 * </ul>
 */
package ${package}.domain.xxx.model.entity;