#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/**
 * 值对象；
 * <p>
 * 1. 用于描述对象属性的值，如一个库表中有json后者一个字段多个属性信息的枚举对象 <br/>
 * 2. 对象名称如；<code>XxxVO</code> <br/>
 * <p>
 * 值对象（Value Object）在领域服务方法的生命周期过程中是不可变的对象，也没有唯一标识。它通常与实体对象配合使用，
 * 例如为实体对象提供属性值的描述，如一个公司雇员的级别值对象，或一个下单商品的四级地址信息对象。
 * 因此，在开发值对象时，通常不会提供 setter 方法，而是通过构造函数或 Builder 方法来实例化对象。
 * 这个对象通常不会独立作为方法的入参对象，但可以独立作为出参对象使用。
 * <p>
 * <h4>概念</h4>
 * <p><strong>值对象</strong>是由一组属性组成的，它们共同描述了一个领域概念。与实体（Entity）不同，值对象不需要有一个唯一的标识符来区分它们。
 * 值对象通常是不可变的，这意味着一旦创建，它们的状态就不应该改变。</p>
 *
 * <h4>特征</h4>
 * <ul>
 *   <li><strong>不可变性 (Immutability)：</strong>值对象一旦被创建，其状态就不应该发生变化。这有助于保证领域模型的一致性和线程安全性。</li>
 *   <li><strong>等价性 (Equality)：</strong>值对象的等价性不是基于身份或引用，而是基于对象的属性值。如果两个值对象的所有属性值都相等，那么这两个对象就被认为是等价的。</li>
 *   <li><strong>替换性 (Replace-ability)：</strong>由于值对象是不可变的，任何需要改变值对象的操作都会导致创建一个新的值对象实例，而不是修改现有的实例。</li>
 *   <li><strong>侧重于描述事物的状态：</strong>值对象通常用来描述事物的状态，而不是事物的唯一身份。</li>
 *   <li><strong>可复用性 (Reusability)：</strong>值对象可以在不同的领域实体或其他值对象中重复使用。</li>
 * </ul>
 *
 * <h4>用途</h4>
 * <ul>
 *   <li>金额和货币（如价格、工资、费用等）</li>
 *   <li>度量和数据（如重量、长度、体积等）</li>
 *   <li>范围或区间（如日期范围、温度区间等）</li>
 *   <li>复杂的数学模型（如坐标、向量等）</li>
 *   <li>任何其它需要封装的属性集合</li>
 * </ul>
 *
 * <h4>实现手段</h4>
 * <ul>
 *   <li><strong>定义不可变类：</strong>确保类的所有属性都是私有的，并且只能通过构造函数（或 Builder）来设置。</li>
 *   <li><strong>重写 equals 或 hashCode 方法：</strong>这样可以确保值对象的等价性是基于它们的属性值，而不是对象的引用。</li>
 *   <li><strong>提供只读访问器：</strong>只提供 getter 方法，不提供 setter 方法。</li>
 *   <li><strong>使用工厂方法或构造函数创建实例：</strong>这有助于确保值对象的有效性和一致性。</li>
 *   <li><strong>考虑序列化支持：</strong>如果值对象需要在网络上传输或存储到数据库中，需要提供序列化和反序列化的支持。</li>
 * </ul>
 */
package ${package}.domain.xxx.model.valobj;