/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire;

import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;

public enum CurrencyType {
    MONEY{

        @Override
        public void sendNoMoney(Player player, double money) {
            MessageUtil.sendMessage((String)"sapphire.no-money", (CommandSender)player, (MessageData[])new MessageData[]{new MessageData("player", (Object)player), new MessageData("needed", (Object)money), new MessageData("missing", (Object)(money - this.get(player)))});
        }

        @Override
        public boolean canPay(Player player, double money) {
            return CodexEngine.getEngine().getVault().canPay((OfflinePlayer)player, money);
        }

        @Override
        public boolean pay0(Player player, double money) {
            return CodexEngine.getEngine().getVault().take((OfflinePlayer)player, money);
        }

        @Override
        public double get(Player player) {
            return CodexEngine.getEngine().getVault().getBalance((OfflinePlayer)player);
        }

        @Override
        public boolean add(Player player, double money) {
            return CodexEngine.getEngine().getVault().give((OfflinePlayer)player, money);
        }

        @Override
        public void reset(Player player) {
            CodexEngine.getEngine().getVault().reset((OfflinePlayer)player);
        }
    }
    ,
    POINTS{
        private final PlayerPointsAPI plugin = ((PlayerPoints)PlayerPoints.getPlugin(PlayerPoints.class)).getAPI();

        @Override
        public void sendNoMoney(Player player, double money) {
            MessageUtil.sendMessage((String)"sapphire.no-points", (CommandSender)player, (MessageData[])new MessageData[]{new MessageData("player", (Object)player), new MessageData("needed", (Object)money), new MessageData("missing", (Object)(money - this.get(player)))});
        }

        @Override
        public boolean canPay(Player player, double money) {
            return this.get(player) >= (double)((int)money);
        }

        @Override
        public boolean pay0(Player player, double money) {
            return this.plugin.take(player.getUniqueId(), (int)money);
        }

        @Override
        public double get(Player player) {
            return this.plugin.look(player.getUniqueId());
        }

        @Override
        public boolean add(Player player, double money) {
            return this.plugin.give(player.getUniqueId(), (int)money);
        }

        @Override
        public void reset(Player player) {
            this.plugin.reset(player.getUniqueId());
        }
    };


    public boolean canPay(Player player, double money, boolean sendMessage) {
        if (this.canPay(player, money)) {
            return true;
        }
        if (sendMessage) {
            this.sendNoMoney(player, money);
        }
        return false;
    }

    public boolean pay(Player player, double money) {
        if (!this.canPay(player, money)) {
            return false;
        }
        return this.pay0(player, money);
    }

    public abstract void sendNoMoney(Player var1, double var2);

    public abstract boolean canPay(Player var1, double var2);

    protected abstract boolean pay0(Player var1, double var2);

    public abstract double get(Player var1);

    public abstract boolean add(Player var1, double var2);

    public abstract void reset(Player var1);
}

