/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItemImpl;
import studio.magemonkey.sapphire.Sapphire;

public class DarkRiseItems {
    private static final String ALLOWED_CHARS = "1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM -_.";
    private final File dataFile = new File(Sapphire.getInstance().getDataFolder(), "items");
    private final Map<String, DarkRiseItem> itemsById = new ConcurrentHashMap<String, DarkRiseItem>(200);
    private final Map<String, File> itemFiles = new ConcurrentHashMap<String, File>(200);
    private final Map<String, DarkRiseItem> itemsByName = new ConcurrentHashMap<String, DarkRiseItem>(200);
    private final SortedMap<String, DarkRiseItem> sortedItems = Collections.synchronizedSortedMap(new TreeMap());

    public Collection<DarkRiseItem> getItems() {
        return this.itemsById.values();
    }

    public SortedMap<String, DarkRiseItem> getSortedMap() {
        return this.sortedItems;
    }

    public DarkRiseItem addItem(String fileName, DarkRiseItem item, boolean save) {
        Validate.notNull((Object)item, (String)"Item can't be null", (Object[])new Object[0]);
        if (!((String)fileName).toLowerCase().endsWith(".yml")) {
            fileName = (String)fileName + ".yml";
        }
        StringBuilder sb = new StringBuilder(((String)fileName).length());
        for (char c : ((String)fileName).toCharArray()) {
            if (ALLOWED_CHARS.indexOf(c) == -1) continue;
            sb.append(c);
        }
        File file = new File(this.dataFile, sb.toString());
        return this.addItem(file, item, save);
    }

    public DarkRiseItem addItem(File file, DarkRiseItem item, boolean save) {
        Validate.notNull((Object)item, (String)"Item can't be null", (Object[])new Object[0]);
        String lowerId = item.getId().toLowerCase().intern();
        if (file != null) {
            this.itemFiles.put(lowerId, file);
        }
        this.itemsByName.put(item.getName().toLowerCase().intern(), item);
        this.itemsById.put(lowerId, item);
        this.sortedItems.put(item.getId(), item);
        if (save) {
            Sapphire.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)Sapphire.getInstance(), this::saveItems);
        }
        return item;
    }

    public boolean removeItem(DarkRiseItem item, boolean save) {
        boolean result;
        if (item == null) {
            return false;
        }
        DarkRiseItem remove = this.itemsById.remove(item.getId().toLowerCase());
        if (remove == null) {
            return false;
        }
        File file = this.itemFiles.remove(item.getId().toLowerCase());
        if (file != null) {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
            Collection items = yaml.getMapList("items").stream().map(m -> new DarkRiseItemImpl(m)).collect(Collectors.toSet());
            items.remove(item);
            if (items.isEmpty()) {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            } else {
                Collection toSave = items.stream().map(DarkRiseItemImpl::serialize).collect(Collectors.toList());
                yaml.set("items", (Object)toSave);
                try {
                    yaml.save(file);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't remove item from file: " + String.valueOf(file) + ", error when saving file.");
                }
            }
        }
        this.sortedItems.remove(item.getId());
        boolean bl = result = this.itemsByName.remove(item.getName().toLowerCase()) != null;
        if (save) {
            Sapphire.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)Sapphire.getInstance(), this::saveItems);
        }
        return result;
    }

    public DarkRiseItem getItemByIdOrName(String id) {
        DarkRiseItem itemById = this.getItemById(id);
        if (itemById == null) {
            return this.getItemByName(id);
        }
        return itemById;
    }

    public DarkRiseItem getItemById(String id) {
        if (id == null) {
            return null;
        }
        return this.itemsById.get(id.toLowerCase());
    }

    public DarkRiseItem getItemByName(String name) {
        if (name == null) {
            return null;
        }
        return this.itemsByName.get(name.toLowerCase());
    }

    public boolean canDrop(ItemStack itemStack) {
        DarkRiseItem item = this.getItemByStack(itemStack);
        return item == null || item.canDrop() && item.isTradeable();
    }

    public DarkRiseItem getItemByStack(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return this.getVanillaItemByStack(itemStack);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!itemMeta.hasDisplayName()) {
            return this.getVanillaItemByStack(itemStack);
        }
        return this.getItemByName(itemMeta.getDisplayName());
    }

    public DarkRiseItem getVanillaItemByStack(ItemStack itemStack) {
        return itemStack == null ? null : this.getItemById("vanilla_" + itemStack.getType().name());
    }

    public synchronized void saveItems() {
        HashMap<File, Collection> data = new HashMap<File, Collection>(20);
        for (DarkRiseItem darkRiseItem : this.itemsById.values()) {
            if (darkRiseItem.isVanilla()) continue;
            File file = this.itemFiles.get(darkRiseItem.getId().toLowerCase());
            Collection items = data.computeIfAbsent(file, k -> new ArrayList(20));
            items.add(darkRiseItem);
        }
        for (Map.Entry entry : data.entrySet()) {
            try {
                File saveFile = (File)entry.getKey();
                if (!saveFile.exists()) {
                    saveFile.getAbsoluteFile().getParentFile().mkdirs();
                    saveFile.createNewFile();
                }
                YamlConfiguration yml = new YamlConfiguration();
                yml.set("items", entry.getValue());
                yml.save(saveFile);
            }
            catch (IOException e) {
                Sapphire.getInstance().error("Can't save items to file: " + String.valueOf(entry));
                e.printStackTrace();
            }
        }
    }

    public void loadItems(File dataFile) {
        this.itemFiles.clear();
        this.itemsById.clear();
        this.itemsByName.clear();
        this.sortedItems.clear();
        this.dataFile.mkdirs();
        File[] files = dataFile.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadItems(file);
            } else if (!file.getName().endsWith(".yml")) continue;
            try {
                YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
                yaml.getList("items").forEach(i -> this.addItem(file, (DarkRiseItem)i, false));
            }
            catch (Exception e) {
                Sapphire.getInstance().getLogger().warning("Could not load " + file.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.saveItems();
    }

    public void loadItems() {
        this.loadItems(this.dataFile);
        Sapphire.getInstance().info("Loaded " + this.sortedItems.size() + " items from " + this.itemFiles.size() + " files.");
        this.addVanillaItems();
    }

    private void addVanillaItems() {
        for (Material material : Material.values()) {
            if (!material.isItem() || this.getItemById("vanilla_" + material.name()) != null) continue;
            DarkRiseItemImpl riseItem = new DarkRiseItemImpl("vanilla_" + material.name().toLowerCase(), new ItemStack(material));
            this.addItem((File)null, (DarkRiseItem)riseItem, false);
        }
    }
}

