/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.codex.config.legacy.LegacyConfigManager;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderRegistry;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderType;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.codex.util.messages.NMSPlayerUtils;
import studio.magemonkey.sapphire.CurrencyType;
import studio.magemonkey.sapphire.DarkRiseItems;
import studio.magemonkey.sapphire.Price;
import studio.magemonkey.sapphire.Register;
import studio.magemonkey.sapphire.SapphireItemProvider;
import studio.magemonkey.sapphire.cfg.PlayerData;
import studio.magemonkey.sapphire.cfg.SapphireConfig;
import studio.magemonkey.sapphire.cfg.VoucherManager;

public class Sapphire
extends JavaPlugin {
    public static final PlaceholderType<DarkRiseItem> RISE_ITEM = PlaceholderType.create((String)"riseItem", DarkRiseItem.class, (PlaceholderType[])new PlaceholderType[0]);
    public static final PlaceholderType<SapphireConfig> SAPPHIRE_CONFIG = PlaceholderType.create((String)"sapphireConfig", SapphireConfig.class, (PlaceholderType[])new PlaceholderType[0]);
    private static Sapphire instance;
    private final File itemsToAddFile = new File(this.getDataFolder(), "itemstoadd.yml");
    private final Map<UUID, Map<DarkRiseItem, Integer>> itemsToAdd = new HashMap<UUID, Map<DarkRiseItem, Integer>>();
    private DarkRiseItems items;
    private FileConfiguration config;

    public Sapphire() {
        instance = this;
    }

    public static DarkRiseItems getItemsRegistry() {
        return Sapphire.instance.items;
    }

    public FileConfiguration getCfg() {
        return this.config;
    }

    public int getTimeout() {
        return this.config.getInt("timeout");
    }

    public void reloadConfigs() {
        this.reloadConfig();
        this.items = new DarkRiseItems();
        this.items.loadItems();
        this.config = LegacyConfigManager.loadConfigFile((File)new File(this.getDataFolder(), "config.yml"), (InputStream)this.getResource("config.yml"));
        FileConfiguration lang = LegacyConfigManager.loadConfigFile((File)new File(String.valueOf(this.getDataFolder()) + File.separator + "lang", "lang_en.yml"), (InputStream)this.getResource("lang/lang_en.yml"));
        MessageUtil.reload((FileConfiguration)lang, (Plugin)this);
    }

    public void saveConfigs() {
        this.items.saveItems();
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().isPluginEnabled("PlayerPoints")) {
            PlaceholderRegistry.PLAYER.registerItem("points", CurrencyType.POINTS::get);
        }
        RISE_ITEM.registerItem("name", item -> {
            TextComponent textComponent = new TextComponent(item.getName());
            textComponent.setHoverEvent(NMSPlayerUtils.convert((ItemStack)item.getItem()));
            return textComponent;
        });
        RISE_ITEM.registerItem("displayName", item -> {
            TextComponent textComponent = new TextComponent(item.getName());
            textComponent.setHoverEvent(NMSPlayerUtils.convert((ItemStack)item.getItem()));
            return textComponent;
        });
        RISE_ITEM.registerItem("material", d -> d.getItem().getType());
        RISE_ITEM.registerItem("id", item -> {
            TextComponent textComponent = new TextComponent(item.getId());
            textComponent.setHoverEvent(NMSPlayerUtils.convert((ItemStack)item.getItem()));
            return textComponent;
        });
        RISE_ITEM.registerItem("lore", c -> StringUtils.join((Iterable)c.getItem().getItemMeta().getLore(), (char)'\n'));
        RISE_ITEM.registerItem("enchantments", c -> StringUtils.join(c.getItem().getEnchantments().keySet(), (String)", "));
        SAPPHIRE_CONFIG.registerItem("timeout", SapphireConfig::getTimeout);
        RISE_ITEM.registerChild("item", PlaceholderRegistry.ITEM, DarkRiseItem::getItem);
        super.onLoad();
    }

    public void onEnable() {
        super.onEnable();
        ConfigurationSerialization.registerClass(Price.class);
        PlayerData.init();
        this.reloadConfigs();
        this.loadItemsToAdd();
        try {
            VoucherManager.getInstance().load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Codex")) {
            SapphireItemProvider.register();
        }
        Register.register(this);
    }

    public void onDisable() {
        super.onDisable();
        this.saveConfigs();
        try {
            this.saveItemsToAdd();
            VoucherManager.getInstance().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SapphireItemProvider.unregister();
    }

    public void info(String msg) {
        this.getLogger().info(msg);
    }

    public void error(String msg) {
        this.getLogger().warning(msg);
    }

    public BukkitTask runTaskLater(Runnable run, long delay) {
        return this.getServer().getScheduler().runTaskLater((Plugin)this, run, delay);
    }

    public BukkitTask runTask(Runnable run) {
        return this.getServer().getScheduler().runTask((Plugin)this, run);
    }

    public Map<DarkRiseItem, Integer> addItems(Player player, Map<DarkRiseItem, Integer> map) {
        PlayerInventory inv = player.getInventory();
        HashMap<DarkRiseItem, Integer> playerMap = new HashMap<DarkRiseItem, Integer>();
        if (this.itemsToAdd.containsKey(player.getUniqueId())) {
            playerMap.putAll(this.itemsToAdd.get(player.getUniqueId()));
        }
        if (map != null) {
            map.forEach((item, amount) -> {
                if (playerMap.containsKey(item)) {
                    amount = amount + (Integer)playerMap.get(item);
                }
                playerMap.put((DarkRiseItem)item, (Integer)amount);
            });
        }
        if (playerMap.isEmpty()) {
            return new HashMap<DarkRiseItem, Integer>();
        }
        ItemStack[] itemsArray = (ItemStack[])playerMap.entrySet().stream().map(e -> ((DarkRiseItem)e.getKey()).getItem(((Integer)e.getValue()).intValue())).toArray(ItemStack[]::new);
        HashMap notAdded = inv.addItem(itemsArray);
        Map<DarkRiseItem, Integer> notAddedRise = notAdded.entrySet().stream().collect(Collectors.toMap(e -> this.getItems().getItemByStack((ItemStack)e.getValue()), e -> ((ItemStack)e.getValue()).getAmount()));
        this.itemsToAdd.put(player.getUniqueId(), notAddedRise);
        if (this.itemsToAdd.containsKey(player.getUniqueId()) && this.itemsToAdd.get(player.getUniqueId()).isEmpty()) {
            this.itemsToAdd.remove(player.getUniqueId());
        }
        return playerMap.entrySet().stream().filter(e -> !notAddedRise.containsKey(e.getKey()) || !Objects.equals(notAddedRise.get(e.getKey()), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void dropItems(Location loc, Map<DarkRiseItem, Integer> map) {
        map.keySet().forEach(item -> {
            Item it = loc.getWorld().dropItem(loc, item.getItem(((Integer)map.get(item)).intValue()));
            it.setPickupDelay(1);
        });
    }

    public Map<DarkRiseItem, Integer> addItems(Player player, final DarkRiseItem item, final Integer amount) {
        return this.addItems(player, (Map<DarkRiseItem, Integer>)new HashMap<DarkRiseItem, Integer>(){
            {
                this.put(item, amount);
            }
        });
    }

    public void dropItems(Location loc, final DarkRiseItem item, final Integer amount) {
        this.dropItems(loc, (Map<DarkRiseItem, Integer>)new HashMap<DarkRiseItem, Integer>(){
            {
                this.put(item, amount);
            }
        });
    }

    public Map<DarkRiseItem, Integer> checkItemsToAdd(Player player) {
        return this.addItems(player, null);
    }

    public void checkItemsToAdd() {
        Bukkit.getOnlinePlayers().stream().filter(o -> this.itemsToAdd.containsKey(o.getUniqueId())).forEach(this::checkItemsToAdd);
    }

    public void saveItemsToAdd() throws IOException {
        YamlConfiguration cfg = new YamlConfiguration();
        this.itemsToAdd.forEach((uuid, map) -> {
            ConfigurationSection section = cfg.createSection(uuid.toString());
            map.forEach((item, amount) -> section.set(item.getId(), amount));
        });
        cfg.save(this.itemsToAddFile);
    }

    public void loadItemsToAdd() {
        this.itemsToAdd.clear();
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)this.itemsToAddFile);
        cfg.getKeys(false).forEach(uuid -> {
            HashMap itemMap = new HashMap();
            cfg.getConfigurationSection(uuid).getValues(false).forEach((itemName, amount) -> itemMap.put(this.getItems().getItemById((String)itemName), (Integer)amount));
            this.itemsToAdd.put(UUID.fromString(uuid), itemMap);
        });
    }

    @Generated
    public static Sapphire getInstance() {
        return instance;
    }

    @Generated
    public Map<UUID, Map<DarkRiseItem, Integer>> getItemsToAdd() {
        return this.itemsToAdd;
    }

    @Generated
    public DarkRiseItems getItems() {
        return this.items;
    }
}

