/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire;

import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.items.CodexItemManager;
import studio.magemonkey.codex.items.ItemType;
import studio.magemonkey.codex.items.providers.ICodexItemProvider;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.sapphire.Sapphire;

public class SapphireItemProvider
implements ICodexItemProvider<SapphireItemType> {
    public static String NAMESPACE = "SAPPHIRE";

    public static void register() {
        CodexEngine.getEngine().getItemManager().registerProvider(NAMESPACE, (ICodexItemProvider)new SapphireItemProvider());
    }

    public static void unregister() {
        CodexEngine.getEngine().getItemManager().unregisterProvider(SapphireItemProvider.class);
    }

    public String pluginName() {
        return "Sapphire";
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public ICodexItemProvider.Category getCategory() {
        return ICodexItemProvider.Category.PRO;
    }

    public SapphireItemType getItem(String id) {
        id = CodexItemManager.stripPrefix((String)NAMESPACE, (String)id);
        DarkRiseItem riseItem = Sapphire.getItemsRegistry().getItemById(id);
        if (riseItem == null) {
            return null;
        }
        return new SapphireItemType(riseItem);
    }

    @Nullable
    public SapphireItemType getItem(ItemStack item) {
        DarkRiseItem riseItem = Sapphire.getItemsRegistry().getItemByStack(item);
        if (riseItem == null || riseItem.getId().startsWith("vanilla_")) {
            return null;
        }
        return new SapphireItemType(riseItem);
    }

    public boolean isCustomItem(ItemStack item) {
        DarkRiseItem riseItem = Sapphire.getItemsRegistry().getItemByStack(item);
        return riseItem != null && !riseItem.getId().startsWith("vanilla_");
    }

    public boolean isCustomItemOfId(ItemStack item, String id) {
        id = CodexItemManager.stripPrefix((String)NAMESPACE, (String)id);
        DarkRiseItem riseItem = Sapphire.getItemsRegistry().getItemByStack(item);
        if (riseItem == null || riseItem.getId().startsWith("vanilla_")) {
            return false;
        }
        return riseItem.getId().equals(id);
    }

    public static class SapphireItemType
    extends ItemType {
        private final DarkRiseItem riseItem;

        public SapphireItemType(DarkRiseItem riseItem) {
            this.riseItem = riseItem;
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public String getID() {
            return this.riseItem.getId();
        }

        public ICodexItemProvider.Category getCategory() {
            return ICodexItemProvider.Category.PRO;
        }

        public ItemStack create() {
            return this.riseItem.getItem();
        }

        public boolean isInstance(ItemStack item) {
            DarkRiseItem riseItem = Sapphire.getItemsRegistry().getItemByStack(item);
            if (riseItem == null || riseItem.getId().startsWith("vanilla_")) {
                return false;
            }
            return riseItem.getId().equals(this.riseItem.getId());
        }

        public DarkRiseItem getRiseItem() {
            return this.riseItem;
        }
    }
}

