/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.cfg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.sapphire.Sapphire;

public final class PlayerData {
    private static final Map<UUID, List<ItemStack>> items = new HashMap<UUID, List<ItemStack>>(20, 0.4f);
    private static File dataFile;
    private static FileConfiguration cfg;

    private PlayerData() {
    }

    public static void init() {
        dataFile = new File(Sapphire.getInstance().getDataFolder(), "players.yml");
        if (!dataFile.exists()) {
            dataFile.getAbsoluteFile().getParentFile().mkdirs();
            try {
                dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        cfg = YamlConfiguration.loadConfiguration((File)dataFile);
        for (String sUuid : cfg.getKeys(false)) {
            List its = cfg.getList(sUuid);
            if (its == null || its.isEmpty()) continue;
            items.put(UUID.fromString(sUuid), its);
        }
    }

    public static void dumpPlayer(Player player, ArrayList<ItemStack> keeps) {
        HashMap removes = new HashMap(20);
        if (keeps.isEmpty()) {
            return;
        }
        items.put(player.getUniqueId(), keeps);
        cfg.set(player.getUniqueId().toString(), keeps);
        try {
            cfg.save(dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadPlayer(Player player) {
        List<ItemStack> items = PlayerData.items.remove(player.getUniqueId());
        if (items == null || items.isEmpty()) {
            return;
        }
        cfg.set(player.getUniqueId().toString(), null);
        try {
            cfg.save(dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.getInventory().addItem(items.toArray(new ItemStack[0]));
    }
}

