/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.cfg;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.sapphire.Sapphire;

public class VoucherManager {
    private static VoucherManager instance;
    private final File vouchersFile;
    private int nextId = 1;
    private final Map<Integer, VoucherData> data = new HashMap<Integer, VoucherData>();
    private final Pattern idPattern = Pattern.compile("[0-9]+");

    private VoucherManager() {
        this.vouchersFile = new File(Sapphire.getInstance().getDataFolder(), "vouchers.yml");
    }

    public static VoucherManager getInstance() {
        if (instance == null) {
            instance = new VoucherManager();
        }
        return instance;
    }

    public boolean isVoucher(ItemStack item) {
        return item.hasItemMeta() && item.getItemMeta().hasLore() && item.getItemMeta().getLore().stream().anyMatch(s -> s.contains("Voucher"));
    }

    public int getId(ItemStack item) {
        Matcher match;
        Optional<String> line = item.getItemMeta().getLore().stream().filter(s -> s.contains("Voucher")).findFirst();
        if (line.isPresent() && (match = this.idPattern.matcher(line.get())).find()) {
            return Integer.parseInt(match.group());
        }
        return 0;
    }

    public ItemStack addNextId(ItemStack item) {
        return VoucherManager.addId(item, this.nextId++);
    }

    public static ItemStack addId(ItemStack item, int id) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (line.contains("{VOUCHER_ID}")) {
                line = line.replace("{VOUCHER_ID}", String.valueOf(id));
            }
            lore.set(i, line);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public void load() throws IOException {
        if (!this.vouchersFile.exists()) {
            if (this.vouchersFile.createNewFile()) {
                this.nextId = 1;
            } else {
                Sapphire.getInstance().getLogger().severe("Failed while creating vouchers.yml vouchersFile.");
            }
            return;
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)this.vouchersFile);
        this.data.clear();
        conf.getMapList("data").stream().map(map -> new VoucherData((Map<String, Object>)map)).forEach(d -> this.data.put(d.id, (VoucherData)d));
        this.nextId = conf.getInt("nextid");
    }

    public void save() throws IOException {
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("nextid", (Object)this.nextId);
        conf.set("data", this.data.values().stream().map(VoucherData::serialize).collect(Collectors.toList()));
        conf.save(this.vouchersFile);
    }

    public void use(Player player, ItemStack item) {
        VoucherData voucherData = new VoucherData(this.getId(item), player.getUniqueId(), System.currentTimeMillis() / 1000L);
        this.data.put(voucherData.id, voucherData);
    }

    public Optional<VoucherData> getData(int id) {
        return Optional.ofNullable(this.data.get(id));
    }

    public Optional<VoucherData> getData(ItemStack item) {
        return this.isVoucher(item) ? this.getData(this.getId(item)) : Optional.empty();
    }

    public class VoucherData
    implements ConfigurationSerializable {
        public final int id;
        public final UUID playerUUID;
        public final long timestamp;

        public VoucherData(int id, UUID playerUUID, long timestamp) {
            this.id = id;
            this.playerUUID = playerUUID;
            this.timestamp = timestamp;
        }

        public VoucherData(Map<String, Object> map) {
            this.id = (Integer)map.get("id");
            this.playerUUID = UUID.fromString((String)map.get("uuid"));
            this.timestamp = ((Integer)map.get("timestamp")).intValue();
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            map.put("uuid", this.playerUUID.toString());
            map.put("timestamp", this.timestamp);
            return map;
        }
    }
}

