/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.commands;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.DoubleRange;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.legacy.command.RiseCommand;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItemImpl;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.sapphire.Sapphire;
import studio.magemonkey.sapphire.commands.SapphireItemsCommand;

public class SapphireItemsCreateCommand
extends RiseCommand {
    private static final int PAGE_SIZE = 15;
    private final Sapphire eco;

    public SapphireItemsCreateCommand(Sapphire plugin, SapphireItemsCommand command) {
        super("create", new ArrayList<String>(Arrays.asList("create", "c")), (RiseCommand)command);
        this.setUsage("Insufficient Arguments");
        this.eco = plugin;
    }

    public void runCommand(CommandSender sender, RiseCommand command, String label, String[] args) {
        if (args.length == 0) {
            this.sendUsage(command.getUsage(), sender, command, args);
            return;
        }
        if (!(sender instanceof Player)) {
            MessageUtil.sendMessage((String)"senderIsNotPlayer", (CommandSender)sender, (MessageData[])new MessageData[0]);
            return;
        }
        if (!this.checkPermission(sender, "sapphire.items.create")) {
            return;
        }
        ItemStack mainHand = ((Player)sender).getInventory().getItemInMainHand();
        if (mainHand == null || mainHand.getType() == Material.AIR) {
            MessageUtil.sendMessage((String)"sapphire.commands.create.no-item", (CommandSender)sender, (MessageData[])new MessageData[0]);
            return;
        }
        String id = args[0];
        boolean dropOnDeath = true;
        boolean confirmOnUse = false;
        boolean canDrop = true;
        int removeOnDeath = 1;
        int removeOnUse = 0;
        Object fileName = id + ".yml";
        DoubleRange chanceToLostDurability = DoubleRange.of((double)0.0, (double)0.0);
        String prev = "";
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-dropOnDeath")) {
                dropOnDeath = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-dontDropOnDeath") || arg.equalsIgnoreCase("-don'tDropOnDeath") || arg.equalsIgnoreCase("-doNotDropOnDeath")) {
                dropOnDeath = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-confirmOnUse")) {
                confirmOnUse = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-dontConfirmOnUse") || arg.equalsIgnoreCase("-don'tConfirmOnUse") || arg.equalsIgnoreCase("-doNotConfirmOnUse")) {
                confirmOnUse = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-canDrop")) {
                canDrop = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-dontCanDrop") || arg.equalsIgnoreCase("-doNotCanDrop") || arg.equalsIgnoreCase("-CantDrop") || arg.equalsIgnoreCase("-Can'tDrop") || arg.equalsIgnoreCase("-CanNotDrop")) {
                canDrop = false;
                continue;
            }
            if (prev.equalsIgnoreCase("-removeOnDeath") || prev.equalsIgnoreCase("-remOnDeath") || prev.equalsIgnoreCase("-delOnDeath") || prev.equalsIgnoreCase("-deleteOnDeath")) {
                int i;
                prev = "";
                try {
                    i = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    MessageUtil.sendMessage((String)"notANumber", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("text", (Object)arg)});
                    return;
                }
                removeOnDeath = i;
                continue;
            }
            if (prev.equalsIgnoreCase("-removeOnUse") || prev.equalsIgnoreCase("-remOnUse") || prev.equalsIgnoreCase("-delOnUse") || prev.equalsIgnoreCase("-deleteOnUse")) {
                int i;
                prev = "";
                try {
                    i = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    MessageUtil.sendMessage((String)"notANumber", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("text", (Object)arg)});
                    return;
                }
                removeOnUse = i;
                continue;
            }
            if (prev.equalsIgnoreCase("-file") || prev.equalsIgnoreCase("-f") || prev.equalsIgnoreCase("-catalog")) {
                prev = "";
                fileName = arg;
                continue;
            }
            if (prev.equalsIgnoreCase("-dura") || prev.equalsIgnoreCase("-durability")) {
                prev = "";
                DoubleRange doubleRange = DoubleRange.of((double)0.0, (double)Double.parseDouble(arg));
                if (doubleRange == null) {
                    this.sendUsage(command.getUsage(), sender, command, args);
                    return;
                }
                chanceToLostDurability = doubleRange;
                continue;
            }
            if (!prev.equalsIgnoreCase("")) {
                this.sendUsage(command.getUsage(), sender, command, args);
                return;
            }
            prev = arg;
        }
        if (!mainHand.hasItemMeta()) {
            ItemMeta meta = mainHand.getItemMeta();
            meta.setDisplayName(StringUtils.capitalize((String)mainHand.getType().name().toLowerCase()));
            mainHand.setItemMeta(meta);
        }
        DarkRiseItemImpl riseItem = new DarkRiseItemImpl(id, mainHand, dropOnDeath, removeOnDeath, confirmOnUse, removeOnUse, canDrop, !chanceToLostDurability.equals((Object)DoubleRange.of((double)0.0, (double)0.0)), chanceToLostDurability, new ArrayList());
        try {
            this.eco.getItems().addItem((String)fileName, (DarkRiseItem)riseItem, true);
        }
        catch (IllegalArgumentException e) {
            this.eco.getLogger().warning("Could not load item '" + (String)fileName + "'");
            e.printStackTrace();
        }
        MessageUtil.sendMessage((String)"sapphire.commands.create.done", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("riseItem", (Object)riseItem)});
    }
}

