/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.commands;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.legacy.command.RiseCommand;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.sapphire.Sapphire;
import studio.magemonkey.sapphire.commands.SapphireItemsCommand;

public class SapphireItemsGiveCommand
extends RiseCommand {
    private static final int PAGE_SIZE = 15;
    private final Sapphire eco;
    private final SapphireItemsCommand command;

    public SapphireItemsGiveCommand(Sapphire plugin, SapphireItemsCommand command) {
        super("give", Collections.singletonList("gives"), (RiseCommand)command);
        this.eco = plugin;
        this.command = command;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 2) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return this.eco.getItems().getItems().stream().map(DarkRiseItem::getId).collect(Collectors.toList());
        }
        String str = args[0].toLowerCase();
        return this.eco.getItems().getItems().stream().map(DarkRiseItem::getId).filter(id -> id.toLowerCase().startsWith(str)).collect(Collectors.toList());
    }

    public void runCommand(CommandSender sender, RiseCommand command, String label, String[] args) {
        if (!this.checkPermission(sender, "sapphire.items.give")) {
            return;
        }
        if (args.length == 0) {
            this.sendUsage(command.getUsage(), sender, command, args);
            return;
        }
        if (args.length == 1) {
            if (!(sender instanceof Player)) {
                MessageUtil.sendMessage((String)"senderIsNotPlayer", (CommandSender)sender, (MessageData[])new MessageData[0]);
                return;
            }
            DarkRiseItem riseItem = this.eco.getItems().getItemByIdOrName(args[0]);
            if (riseItem == null) {
                MessageUtil.sendMessage((String)"sapphire.commands.noItem", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("name", (Object)args[0])});
                return;
            }
            this.eco.addItems((Player)sender, riseItem, 1);
            if (this.eco.getItemsToAdd().containsKey(((Player)sender).getUniqueId()) && !this.eco.getItemsToAdd().get(((Player)sender).getUniqueId()).isEmpty()) {
                MessageUtil.sendMessage((String)"sapphire.commands.claim.pending", (CommandSender)sender, (MessageData[])new MessageData[0]);
            }
            return;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            MessageUtil.sendMessage((String)"notAPlayer", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("name", (Object)args[0])});
            return;
        }
        DarkRiseItem riseItem = this.eco.getItems().getItemByIdOrName(args[1]);
        if (riseItem == null) {
            MessageUtil.sendMessage((String)"sapphire.commands.noItem", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("name", (Object)args[1])});
            return;
        }
        int amount = 1;
        if (args.length >= 3) {
            try {
                Integer i = Integer.parseInt(args[2]);
                amount = i;
            }
            catch (NumberFormatException e) {
                MessageUtil.sendMessage((String)"notANumber", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("text", (Object)args[2])});
                return;
            }
        }
        this.eco.addItems(target, riseItem, amount);
        MessageUtil.sendMessage((String)"sapphire.commands.give.success", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("riseItem", (Object)riseItem)});
        if (this.eco.getItemsToAdd().containsKey(target.getUniqueId()) && !this.eco.getItemsToAdd().get(target.getUniqueId()).isEmpty()) {
            MessageUtil.sendMessage((String)"sapphire.commands.claim.pending", (CommandSender)target, (MessageData[])new MessageData[0]);
        }
    }
}

