/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.legacy.command.RiseCommand;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.codex.util.messages.NMSPlayerUtils;
import studio.magemonkey.sapphire.Sapphire;
import studio.magemonkey.sapphire.commands.SapphireItemsCommand;

public class SapphireItemsListCommand
extends RiseCommand {
    private static final int PAGE_SIZE = 15;
    private final Sapphire eco;

    public SapphireItemsListCommand(Sapphire plugin, SapphireItemsCommand command) {
        super("list", List.of("list", "ls"), (RiseCommand)command);
        this.eco = plugin;
    }

    public void runCommand(CommandSender sender, RiseCommand command, String label, String[] args) {
        if (!this.checkPermission(sender, "sapphire.items.list")) {
            return;
        }
        SortedMap<String, DarkRiseItem> map = this.eco.getItems().getSortedMap();
        int page = 0;
        if (args.length >= 1) {
            try {
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        MessageData pageMsgData = new MessageData("page", (Object)(page + 1));
        int index = 0;
        MessageUtil.sendMessage((String)"sapphire.commands.items.list-header", (CommandSender)sender, (MessageData[])new MessageData[]{pageMsgData, new MessageData("sender", (Object)sender)});
        for (Map.Entry<String, DarkRiseItem> entry : map.entrySet()) {
            if (++index <= 15 * page) continue;
            if (index > 15 * page + 15) break;
            TextComponent textComponent = new TextComponent("");
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/econ items give " + sender.getName() + " " + entry.getKey() + " 1"));
            textComponent.setHoverEvent(NMSPlayerUtils.convert((ItemStack)entry.getValue().getItem()));
            textComponent.setExtra(Arrays.asList(MessageUtil.getMessageAsComponent((String)"sapphire.commands.items.list-entry", (MessageData[])new MessageData[]{new MessageData("index", (Object)index), new MessageData("riseItem", (Object)entry.getValue())})));
            MessageUtil.sendMessage((CommandSender)sender, (BaseComponent[])new BaseComponent[]{textComponent});
        }
        MessageUtil.sendMessage((String)"sapphire.commands.items.list-footer", (CommandSender)sender, (MessageData[])new MessageData[]{pageMsgData, new MessageData("sender", (Object)sender)});
    }
}

