/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.legacy.command.RiseCommand;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.sapphire.Sapphire;
import studio.magemonkey.sapphire.cfg.VoucherManager;
import studio.magemonkey.sapphire.commands.SapphireItemsCommand;

public class SapphireItemsVoucherCommand
extends RiseCommand {
    private final Sapphire eco;

    public SapphireItemsVoucherCommand(Sapphire plugin, SapphireItemsCommand command) {
        super("voucher", List.of("voucter"), (RiseCommand)command);
        this.eco = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 2) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return this.eco.getItems().getItems().stream().map(DarkRiseItem::getId).collect(Collectors.toList());
        }
        String str = args[0].toLowerCase();
        return this.eco.getItems().getItems().stream().map(DarkRiseItem::getId).filter(id -> id.toLowerCase().startsWith(str)).collect(Collectors.toList());
    }

    public void runCommand(CommandSender sender, RiseCommand command, String label, String[] args) {
        if (!this.checkPermission(sender, "sapphire.items.voucher")) {
            return;
        }
        if (args.length != 2 && args.length != 3) {
            this.sendUsage(command.getUsage(), sender, command, args);
            return;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            MessageUtil.sendMessage((String)"notAPlayer", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("name", (Object)args[0])});
            return;
        }
        DarkRiseItem riseItem = this.eco.getItems().getItemById(args[1]);
        if (riseItem == null) {
            MessageUtil.sendMessage((String)"sapphire.commands.noItem", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("name", (Object)args[1])});
            return;
        }
        int amount = 1;
        if (args.length >= 3) {
            Integer i2;
            try {
                i2 = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                MessageUtil.sendMessage((String)"notANumber", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("text", (Object)args[2])});
                return;
            }
            amount = i2;
        }
        ItemStack item = VoucherManager.getInstance().addNextId(riseItem.getItem(amount));
        Player player = target != null ? target : (Player)sender;
        HashMap notAdded = player.getInventory().addItem(new ItemStack[]{item});
        if (!notAdded.isEmpty()) {
            notAdded.forEach((a, i) -> {
                i = i.clone();
                i.setAmount(a.intValue());
                player.getLocation().getWorld().dropItemNaturally(player.getLocation(), i);
            });
        }
    }
}

