/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.commands;

import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import studio.magemonkey.codex.legacy.command.RiseCommand;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.sapphire.Sapphire;
import studio.magemonkey.sapphire.cfg.VoucherManager;
import studio.magemonkey.sapphire.commands.SapphireCommand;

public class SapphireVoucherCommand
extends RiseCommand {
    public SapphireVoucherCommand(Sapphire plugin, SapphireCommand command) {
        super("voucher", Collections.singletonList("voucher"), (RiseCommand)command);
        this.setUsage(command.getUsage());
    }

    public void runCommand(CommandSender sender, RiseCommand command, String label, String[] args) {
        Integer voucherId;
        if (!this.checkPermission(sender, "sapphire.voucher")) {
            return;
        }
        if (args.length != 1) {
            this.sendUsage(command.getUsage(), sender, command, args);
            return;
        }
        try {
            voucherId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            MessageUtil.sendMessage((String)"notANumber", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("text", (Object)args[0])});
            return;
        }
        Optional<VoucherManager.VoucherData> data = VoucherManager.getInstance().getData(voucherId);
        if (data.isPresent()) {
            Date time = new Date(data.get().timestamp * 1000L);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)data.get().playerUUID);
            MessageUtil.sendMessage((String)"sapphire.commands.voucher.info", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("voucher_id", (Object)voucherId), new MessageData("player", (Object)player), new MessageData("date", (Object)time.toString())});
        } else {
            MessageUtil.sendMessage((String)"sapphire.commands.voucher.info-unused", (CommandSender)sender, (MessageData[])new MessageData[]{new MessageData("voucher_id", (Object)voucherId)});
        }
    }
}

