/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.sapphire.listener;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.DoubleRange;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.util.InventoryUtil;
import studio.magemonkey.codex.util.RangeUtil;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.sapphire.DarkRiseItems;
import studio.magemonkey.sapphire.Sapphire;
import studio.magemonkey.sapphire.cfg.PlayerData;
import studio.magemonkey.sapphire.cfg.SapphireConfig;
import studio.magemonkey.sapphire.cfg.VoucherManager;

public class PlayerListener
implements Listener {
    private static final Set<InventoryAction> dropActions = Sets.newIdentityHashSet();
    private static final Set<InventoryType> tradeableInventories = Sets.newIdentityHashSet();
    private final Map<UUID, DarkRiseItem> confirm = new ConcurrentHashMap<UUID, DarkRiseItem>(10, 0.4f, 2);
    private final Map<UUID, Integer> confirmTasks = new ConcurrentHashMap<UUID, Integer>(10, 0.4f, 2);
    private final Sapphire plugin;

    public PlayerListener(Sapphire plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        int removeOnUse;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        ItemStack item = event.getItem();
        DarkRiseItem riseItem = this.plugin.getItems().getItemByStack(item);
        Player p = event.getPlayer();
        if (riseItem == null) {
            return;
        }
        if (!riseItem.getPermission().isEmpty() && riseItem.getPermission().stream().anyMatch(s -> !p.hasPermission(s))) {
            if (riseItem.getPermissionMessage() != null && !riseItem.getPermissionMessage().isEmpty()) {
                p.sendMessage(riseItem.getPermissionMessage());
            }
            return;
        }
        if (riseItem.isEnabledEnchantedDurability()) {
            double random = RangeUtil.getRandomDouble((DoubleRange)riseItem.chanceToLostDurability());
            int forceLost = 0;
            if (random > 1.0) {
                forceLost = (int)random;
                random -= (double)forceLost;
            }
            if (RangeUtil.getChance((double)random)) {
                ++forceLost;
            }
            if (forceLost > 0) {
                item.setDurability((short)(item.getDurability() + forceLost));
            }
        }
        if ((removeOnUse = riseItem.isRemoveOnUse()) > item.getAmount() && !p.getInventory().containsAtLeast(riseItem.getItem(), removeOnUse)) {
            return;
        }
        boolean isVoucher = VoucherManager.getInstance().isVoucher(item);
        Optional<VoucherManager.VoucherData> data = VoucherManager.getInstance().getData(item);
        if (isVoucher && data.isPresent()) {
            MessageUtil.sendMessage((String)"sapphire.commands.voucher.already-used", (CommandSender)event.getPlayer(), (MessageData[])new MessageData[]{new MessageData("voucher_id", (Object)data.get().id)});
            return;
        }
        if (riseItem.isConfirmOnUse()) {
            event.setCancelled(true);
            if (this.confirm.containsKey(p.getUniqueId())) {
                if (riseItem.equals((Object)this.confirm.get(p.getUniqueId()))) {
                    return;
                }
                this.confirm.remove(p.getUniqueId());
                Integer i = this.confirmTasks.remove(p.getUniqueId());
                if (i != null) {
                    Bukkit.getScheduler().cancelTask(i.intValue());
                }
            }
            MessageData yes = new MessageData("yes", (Object)MessageUtil.getMessageAsString((String)"sapphire.yes", (String)"yes", (MessageData[])new MessageData[0]));
            MessageData no = new MessageData("no", (Object)MessageUtil.getMessageAsString((String)"sapphire.no", (String)"no", (MessageData[])new MessageData[0]));
            MessageData config = new MessageData("sapphireConfig", (Object)new SapphireConfig());
            MessageData playerMsg = new MessageData("player", (Object)p);
            MessageData itemMsg = new MessageData("riseItem", (Object)riseItem);
            MessageUtil.sendMessage((String)"sapphire.useWithConfirm", (CommandSender)p, (MessageData[])new MessageData[]{yes, no, config, playerMsg, itemMsg});
            this.confirm.put(p.getUniqueId(), riseItem);
            this.confirmTasks.put(p.getUniqueId(), Sapphire.getInstance().runTaskLater(() -> {
                if (this.confirm.remove(p.getUniqueId()) != null) {
                    this.confirmTasks.remove(p.getUniqueId());
                    MessageUtil.sendMessage((String)"sapphire.timeout", (CommandSender)p, (MessageData[])new MessageData[]{yes, no, config, playerMsg, itemMsg});
                }
            }, (long)this.plugin.getTimeout() * 20L).getTaskId());
            return;
        }
        if (isVoucher) {
            VoucherManager.getInstance().use(event.getPlayer(), item);
        }
        if (removeOnUse > 0) {
            ItemStack removeItem = item.clone();
            removeItem.setAmount(removeOnUse);
            if (!p.getInventory().removeItem(new ItemStack[]{removeItem}).isEmpty()) {
                return;
            }
        }
        riseItem.invoke((CommandSender)p);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Sapphire.getInstance().runTaskLater(() -> PlayerData.loadPlayer(event.getPlayer()), 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.confirm.remove(event.getEntity().getUniqueId());
        this.confirmTasks.remove(event.getEntity().getUniqueId());
        if (event.getKeepInventory()) {
            return;
        }
        if (event.getDrops().isEmpty()) {
            return;
        }
        DarkRiseItems items = this.plugin.getItems();
        ArrayList<ItemStack> keeps = new ArrayList<ItemStack>();
        ArrayList removes = new ArrayList();
        for (ItemStack itemStack : event.getDrops()) {
            DarkRiseItem riseItem = items.getItemByStack(itemStack);
            if (riseItem == null || riseItem.isDropOnDeath() && riseItem.canDrop()) continue;
            keeps.add(itemStack);
        }
        if (!keeps.isEmpty()) {
            event.getDrops().removeAll(keeps);
        }
        PlayerData.dumpPlayer(event.getEntity(), keeps);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.confirm.remove(event.getPlayer().getUniqueId());
        this.confirmTasks.remove(event.getPlayer().getUniqueId());
        PlayerData.loadPlayer(event.getPlayer());
        if (this.plugin.getItemsToAdd().containsKey(event.getPlayer().getUniqueId()) && !this.plugin.getItemsToAdd().get(event.getPlayer().getUniqueId()).isEmpty()) {
            MessageUtil.sendMessage((String)"sapphire.commands.claim.pending", (CommandSender)event.getPlayer(), (MessageData[])new MessageData[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player p = event.getPlayer();
        if (this.confirm.containsKey(p.getUniqueId())) {
            DarkRiseItem item;
            String yes = MessageUtil.getMessageAsString((String)"sapphire.yes", (String)"yes", (boolean)true, (MessageData[])new MessageData[0]);
            String no = MessageUtil.getMessageAsString((String)"sapphire.no", (String)"no", (boolean)true, (MessageData[])new MessageData[0]);
            if (event.getMessage().equalsIgnoreCase(yes) && (item = this.confirm.remove(p.getUniqueId())) != null) {
                Integer i = this.confirmTasks.remove(p.getUniqueId());
                if (i != null) {
                    Bukkit.getScheduler().cancelTask(i.intValue());
                }
                event.setCancelled(true);
                DarkRiseItem powerItem = item;
                Sapphire.getInstance().runTask(() -> {
                    boolean used;
                    boolean bl = used = powerItem.isRemoveOnUse() == 0;
                    if (!used) {
                        int notRemovedAmount;
                        int removedAmount;
                        ItemStack toRemove = powerItem.getItem(powerItem.isRemoveOnUse());
                        int toRemoveAmount = toRemove.getAmount();
                        HashMap removeResult = p.getInventory().removeItem(new ItemStack[]{toRemove});
                        used = removeResult.isEmpty();
                        if (!used && (removedAmount = toRemoveAmount - (notRemovedAmount = toRemove.getAmount())) != 0) {
                            toRemove.setAmount(removedAmount);
                            p.getInventory().addItem(new ItemStack[]{toRemove});
                        }
                    }
                    if (used) {
                        MessageUtil.sendMessage((String)"sapphire.used", (CommandSender)p, (MessageData[])new MessageData[]{new MessageData("no", (Object)no), new MessageData("riseItem", (Object)powerItem)});
                        powerItem.invoke((CommandSender)p);
                    } else {
                        MessageUtil.sendMessage((String)"sapphire.canNotFindItem", (CommandSender)p, (MessageData[])new MessageData[]{new MessageData("no", (Object)no), new MessageData("riseItem", (Object)powerItem)});
                    }
                });
            } else if (event.getMessage().equalsIgnoreCase(no) && (item = this.confirm.remove(p.getUniqueId())) != null) {
                Integer i = this.confirmTasks.remove(p.getUniqueId());
                if (i != null) {
                    Bukkit.getScheduler().cancelTask(i.intValue());
                }
                event.setCancelled(true);
                MessageUtil.sendMessage((String)"sapphire.cancel", (CommandSender)p, (MessageData[])new MessageData[]{new MessageData("no", (Object)no), new MessageData("riseItem", (Object)item)});
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.confirm.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        DarkRiseItems items = Sapphire.getInstance().getItems();
        if (!(!dropActions.contains(event.getAction()) || items.canDrop(event.getCursor()) && items.canDrop(event.getCurrentItem()))) {
            event.setCancelled(true);
            MessageUtil.sendMessage((String)"sapphire.canNotDrop", (CommandSender)event.getWhoClicked(), (MessageData[])new MessageData[0]);
            return;
        }
        if (event.getClickedInventory() == null || !event.getClickedInventory().equals((Object)InventoryUtil.getTopInventory((InventoryEvent)event)) || tradeableInventories.contains(event.getClickedInventory().getType())) {
            return;
        }
        DarkRiseItem item = null;
        if (event.getCursor() != null) {
            item = items.getItemByStack(event.getCursor());
        } else if (event.getCurrentItem() != null) {
            item = items.getItemByStack(event.getCurrentItem());
        }
        if (item == null || item.isTradeable()) {
            return;
        }
        if (event.getAction() == InventoryAction.PLACE_ALL || event.getAction() == InventoryAction.PLACE_ONE || event.getAction() == InventoryAction.PLACE_SOME) {
            event.setCancelled(true);
            MessageUtil.sendMessage((String)"sapphire.canNotTrade", (CommandSender)event.getWhoClicked(), (MessageData[])new MessageData[0]);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        DarkRiseItems items = Sapphire.getInstance().getItems();
        if (!event.getInventory().equals((Object)InventoryUtil.getTopInventory((InventoryEvent)event)) || tradeableInventories.contains(event.getInventory().getType())) {
            return;
        }
        DarkRiseItem item = items.getItemByStack(event.getOldCursor());
        if (item == null || item.isTradeable()) {
            return;
        }
        event.setCancelled(true);
        MessageUtil.sendMessage((String)"sapphire.canNotTrade", (CommandSender)event.getWhoClicked(), (MessageData[])new MessageData[0]);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        DarkRiseItems items = Sapphire.getInstance().getItems();
        if (!items.canDrop(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
            MessageUtil.sendMessage((String)"sapphire.canNotDrop", (CommandSender)event.getPlayer(), (MessageData[])new MessageData[0]);
        }
    }

    static {
        dropActions.add(InventoryAction.DROP_ALL_CURSOR);
        dropActions.add(InventoryAction.DROP_ALL_SLOT);
        dropActions.add(InventoryAction.DROP_ONE_CURSOR);
        dropActions.add(InventoryAction.DROP_ONE_SLOT);
        tradeableInventories.add(InventoryType.ANVIL);
        tradeableInventories.add(InventoryType.CRAFTING);
        tradeableInventories.add(InventoryType.CREATIVE);
        tradeableInventories.add(InventoryType.ENDER_CHEST);
        tradeableInventories.add(InventoryType.ENCHANTING);
        tradeableInventories.add(InventoryType.PLAYER);
        tradeableInventories.add(InventoryType.WORKBENCH);
    }
}

