/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.exception.ConfigErrCodes;

public class FileLoader {
    public static String readLocalFile(String filename) throws GenericException {
        try {
            return FileLoader.readFile(filename);
        }
        catch (IOException e) {
            throw new GenericException(ConfigErrCodes.CONFIG_101, (Throwable)e, "", new Object[]{filename});
        }
    }

    public static Properties loadLocalProps(String filePath) throws GenericException {
        try {
            return FileLoader.loadProps(filePath);
        }
        catch (IOException e) {
            throw new GenericException(ConfigErrCodes.CONFIG_101, (Throwable)e, "", new Object[]{filePath});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String filename) throws IOException {
        String content = null;
        InputStream in = null;
        BufferedReader br = null;
        try {
            StringBuilder sb = new StringBuilder();
            in = FileLoader.class.getClassLoader().getResourceAsStream(filename);
            if (null == in) {
                throw new IOException(filename + " is not found");
            }
            br = new BufferedReader(new InputStreamReader(in, Charset.forName("utf-8")));
            while ((content = br.readLine()) != null) {
                sb.append(content).append("\n");
            }
            content = sb.toString();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProps(String filePath) throws IOException {
        Properties props = new Properties();
        InputStream ips = FileLoader.class.getClassLoader().getResourceAsStream(filePath);
        try {
            props.load(ips);
        }
        finally {
            try {
                ips.close();
            }
            catch (Exception exception) {}
        }
        return props;
    }
}

