/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.config;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.exception.ConfigErrCodes;
import studio.raptor.ddal.config.fetcher.ConfigFetcher;
import studio.raptor.ddal.config.fetcher.FetcherHolder;

public abstract class AbstractConfig {
    protected ConfigFetcher configFetcher = FetcherHolder.get();

    protected boolean validate(String xml, String xsd) throws GenericException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaSrc = new StreamSource(new ByteArrayInputStream(xsd.getBytes("UTF-8")));
            Schema schema = schemaFactory.newSchema(schemaSrc);
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            validator.validate(source);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GenericException(ConfigErrCodes.CONFIG_102, (Throwable)e, "", new Object[]{xml});
        }
    }

    protected String getFileString(String filePath) throws GenericException {
        return this.configFetcher.getFileString(filePath);
    }

    protected Map<String, String> getPropsMap(String filePath) throws GenericException {
        return this.configFetcher.getProperties(filePath);
    }

    public abstract void reload();
}

