/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.config;

import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.common.FileLoader;
import studio.raptor.ddal.config.config.AbstractConfig;
import studio.raptor.ddal.config.model.server.Grants;
import studio.raptor.ddal.config.model.server.Params;
import studio.raptor.ddal.config.model.server.Users;
import studio.raptor.ddal.config.parser.ServerConfigParser;

public class ServerConfig
extends AbstractConfig {
    private static final String SERVER_CONFIG_XSD = "server-config.xsd";
    private Params params;
    private Users users;
    private Grants grants;
    private static ServerConfig instance = new ServerConfig();

    public static ServerConfig getInstance() {
        return instance;
    }

    private ServerConfig() throws GenericException {
        String xmlContent = this.getFileString(this.configFetcher.getServerConfigPath());
        this.validate(xmlContent, FileLoader.readLocalFile(SERVER_CONFIG_XSD));
        ServerConfigParser.parse(this, xmlContent);
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException("ServerConfig reloading is not supported.");
    }

    public Params getParams() {
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    public Users getUsers() {
        return this.users;
    }

    public void setUsers(Users users) {
        this.users = users;
    }

    public Grants getGrants() {
        return this.grants;
    }

    public void setGrants(Grants grants) {
        this.grants = grants;
    }

    public String toString() {
        return "ServerConfig [params=" + this.params + ", users=" + this.users + ", grants=" + this.grants + "]";
    }
}

