/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.config;

import java.util.concurrent.TimeUnit;
import studio.raptor.ddal.common.event.NativeEventBus;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.common.FileLoader;
import studio.raptor.ddal.config.config.AbstractConfig;
import studio.raptor.ddal.config.config.RuleConfig;
import studio.raptor.ddal.config.event.ReloadingEventListener;
import studio.raptor.ddal.config.io.FileHandler;
import studio.raptor.ddal.config.io.FileLocator;
import studio.raptor.ddal.config.model.shard.DataSourceGroups;
import studio.raptor.ddal.config.model.shard.PhysicalDBCluster;
import studio.raptor.ddal.config.model.shard.PhysicalDBClusters;
import studio.raptor.ddal.config.model.shard.ShardGroups;
import studio.raptor.ddal.config.model.shard.VirtualDb;
import studio.raptor.ddal.config.model.shard.VirtualDbs;
import studio.raptor.ddal.config.parser.ShardConfigParser;
import studio.raptor.ddal.config.reloading.FileHandlerReloadingDetector;
import studio.raptor.ddal.config.reloading.PeriodicReloadingTrigger;
import studio.raptor.ddal.config.reloading.ReloadingController;

public class ShardConfig
extends AbstractConfig {
    private static final String SHARD_CONFIG_XSD = "shard-config.xsd";
    private RuleConfig ruleConfig;
    private VirtualDbs virtualDbs;
    private PhysicalDBClusters physicalDBClusters;
    private DataSourceGroups dataSourceGroups;
    private ShardGroups shardGroups;
    private static ShardConfig instance = new ShardConfig();

    public static ShardConfig getInstance() {
        return instance;
    }

    private ShardConfig() throws GenericException {
        this.loadShardConfig();
        NativeEventBus.get().register((Object)new ReloadingEventListener());
        this.registerReloadingController();
    }

    private void loadShardConfig() {
        String xmlContent = this.getFileString(this.configFetcher.getShardConfigPath());
        this.validate(xmlContent, FileLoader.readLocalFile(SHARD_CONFIG_XSD));
        this.ruleConfig = RuleConfig.getInstance();
        ShardConfigParser.parse(this, xmlContent);
    }

    @Override
    public void reload() {
        this.loadShardConfig();
    }

    private void registerReloadingController() {
        if ("L".equals(this.configFetcher.fetchingMode())) {
            new PeriodicReloadingTrigger(new ReloadingController(new FileHandlerReloadingDetector(new FileHandler(new FileLocator.FileLocatorBuilder(null).sourceURL(ShardConfig.class.getClassLoader().getResource(this.configFetcher.getShardConfigPath())).create()))), null, 5000L, TimeUnit.MILLISECONDS).start();
        }
    }

    public RuleConfig getRuleConfig() {
        return this.ruleConfig;
    }

    public VirtualDbs getVirtualDbs() {
        return this.virtualDbs;
    }

    public void setVirtualDbs(VirtualDbs virtualDbs) {
        this.virtualDbs = virtualDbs;
    }

    public VirtualDb getVirtualDb(String dbName) {
        return this.virtualDbs.get(dbName);
    }

    public PhysicalDBClusters getPhysicalDBClusters() {
        return this.physicalDBClusters;
    }

    public void setPhysicalDBClusters(PhysicalDBClusters physicalDBClusters) {
        this.physicalDBClusters = physicalDBClusters;
    }

    public PhysicalDBCluster getPhysicalDBCluster(String clusterName) {
        return this.physicalDBClusters.get(clusterName);
    }

    public DataSourceGroups getDataSourceGroups() {
        return this.dataSourceGroups;
    }

    public void setDataSourceGroups(DataSourceGroups dataSourceGroups) {
        this.dataSourceGroups = dataSourceGroups;
    }

    public ShardGroups getShardGroups() {
        return this.shardGroups;
    }

    public void setShardGroups(ShardGroups shardGroups) {
        this.shardGroups = shardGroups;
    }

    public String toString() {
        return "ShardConfig{virtualDbs=" + this.virtualDbs + ", physicalDBClusters=" + this.physicalDBClusters + ", dataSourceGroups=" + this.dataSourceGroups + ", shardGroups=" + this.shardGroups + '}';
    }
}

