/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.fetcher;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.common.FileLoader;
import studio.raptor.ddal.config.fetcher.ConfigFetcher;

public abstract class LocalConfigFetcher
extends ConfigFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConfigFetcher.class);

    @Override
    public String getFileString(String filePath) throws GenericException {
        Preconditions.checkNotNull((Object)filePath, (Object)"filePath can not be null");
        LOGGER.info("Get file string from local system, file name: {}", (Object)filePath);
        return FileLoader.readLocalFile(filePath);
    }

    @Override
    public String fetchingMode() {
        return "L";
    }

    @Override
    public Map<String, String> getProperties(String filePath) {
        Preconditions.checkNotNull((Object)filePath, (Object)"filePath can not be null");
        LOGGER.info("Get properties from local system, file name: {}", (Object)filePath);
        return LocalConfigFetcher.properties2Map(FileLoader.loadLocalProps(filePath));
    }

    private static Map<String, String> properties2Map(Properties properties) {
        Set<String> keys = properties.stringPropertyNames();
        HashMap<String, String> routeMapping = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            String value = properties.getProperty(key);
            routeMapping.put(key, value);
        }
        return routeMapping;
    }
}

